/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.mapper.generator.formatter;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import tk.mybatis.mapper.generator.formatter.ListTemplateFormatter;
import tk.mybatis.mapper.generator.formatter.TemplateFormatter;
import tk.mybatis.mapper.generator.model.TableClass;

public class FreemarkerTemplateFormatter
implements TemplateFormatter,
ListTemplateFormatter {
    private final Configuration configuration = new Configuration(Configuration.VERSION_2_3_23);
    private final StringTemplateLoader templateLoader = new StringTemplateLoader();

    public FreemarkerTemplateFormatter() {
        this.configuration.setLocale(Locale.CHINA);
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setTemplateLoader((TemplateLoader)this.templateLoader);
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(Configuration.VERSION_2_3_23));
    }

    public String process(String templateName, String templateSource, Map<String, Object> params) {
        try {
            Template template = new Template(templateName, templateSource, this.configuration);
            StringWriter writer = new StringWriter();
            template.process(params, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getFormattedContent(TableClass tableClass, Properties properties, String targetPackage, String templateContent) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Object o : properties.keySet()) {
            params.put(String.valueOf(o), properties.get(o));
        }
        params.put("props", properties);
        params.put("package", targetPackage);
        params.put("tableClass", tableClass);
        return this.process(properties.getProperty("templatePath"), templateContent, params);
    }

    @Override
    public String getFormattedContent(Set<TableClass> tableClassSet, Properties properties, String targetPackage, String templateContent) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (Object o : properties.keySet()) {
            params.put(String.valueOf(o), properties.get(o));
        }
        params.put("props", properties);
        params.put("package", targetPackage);
        params.put("tableClassSet", tableClassSet);
        return this.process(properties.getProperty("templatePath"), templateContent, params);
    }
}

