/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.internal;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ibatis.ibator.api.GeneratedXmlFile;
import org.apache.ibatis.ibator.config.MergeConstants;
import org.apache.ibatis.ibator.exception.ShellException;
import org.apache.ibatis.ibator.internal.DomWriter;
import org.apache.ibatis.ibator.internal.util.messages.Messages;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlFileMergerJaxp {
    private XmlFileMergerJaxp() {
    }

    /*
     * WARNING - void declaration
     */
    public static String getMergedSource(GeneratedXmlFile generatedXmlFile, File existingFile) throws ShellException {
        try {
            void var16_19;
            Node node;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new NullEntityResolver());
            Document existingDocument = builder.parse(existingFile);
            StringReader sr = new StringReader(generatedXmlFile.getFormattedContent());
            Document newDocument = builder.parse(new InputSource(sr));
            DocumentType newDocType = newDocument.getDoctype();
            DocumentType existingDocType = existingDocument.getDoctype();
            if (!newDocType.getName().equals(existingDocType.getName())) {
                throw new ShellException(Messages.getString("Warning.12", existingFile.getName()));
            }
            Element existingRootElement = existingDocument.getDocumentElement();
            Element newRootElement = newDocument.getDocumentElement();
            NamedNodeMap attributes = existingRootElement.getAttributes();
            int attributeCount = attributes.getLength();
            int i = attributeCount - 1;
            while (i >= 0) {
                node = attributes.item(i);
                existingRootElement.removeAttribute(node.getNodeName());
                --i;
            }
            attributes = newRootElement.getAttributes();
            attributeCount = attributes.getLength();
            i = 0;
            while (i < attributeCount) {
                node = attributes.item(i);
                existingRootElement.setAttribute(node.getNodeName(), node.getNodeValue());
                ++i;
            }
            ArrayList<Object> nodesToDelete = new ArrayList<Object>();
            NodeList children = existingRootElement.getChildNodes();
            int length = children.getLength();
            boolean bl = false;
            while (var16_19 < length) {
                Node node2 = children.item((int)var16_19);
                if (XmlFileMergerJaxp.isAnIbatorNode(node2)) {
                    nodesToDelete.add(node2);
                } else if (XmlFileMergerJaxp.isWhiteSpace(node2) && XmlFileMergerJaxp.isAnIbatorNode(children.item((int)(var16_19 + true)))) {
                    nodesToDelete.add(node2);
                }
                ++var16_19;
            }
            for (Node node2 : nodesToDelete) {
                existingRootElement.removeChild(node2);
            }
            children = newRootElement.getChildNodes();
            length = children.getLength();
            Node node3 = existingRootElement.getFirstChild();
            int i3 = 0;
            while (i3 < length) {
                Node node4 = children.item(i3);
                if (i3 == length - 1 && XmlFileMergerJaxp.isWhiteSpace(node4)) break;
                Node newNode = existingDocument.importNode(node4, true);
                if (node3 == null) {
                    existingRootElement.appendChild(newNode);
                } else {
                    existingRootElement.insertBefore(newNode, node3);
                }
                ++i3;
            }
            return XmlFileMergerJaxp.prettyPrint(existingDocument);
        }
        catch (Exception e) {
            throw new ShellException(Messages.getString("Warning.13", existingFile.getName()), e);
        }
    }

    private static String prettyPrint(Document document) throws ShellException {
        DomWriter dw = new DomWriter();
        String s = dw.toString(document);
        return s;
    }

    private static boolean isAnIbatorNode(Node node) {
        boolean rc = false;
        if (node != null && node.getNodeType() == 1) {
            Element element = (Element)node;
            String id = element.getAttribute("id");
            if (id != null) {
                String[] stringArray = MergeConstants.OLD_XML_ELEMENT_PREFIXES;
                int n = MergeConstants.OLD_XML_ELEMENT_PREFIXES.length;
                int n2 = 0;
                while (n2 < n) {
                    String prefix = stringArray[n2];
                    if (id.startsWith(prefix)) {
                        rc = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!rc) {
                NodeList children = node.getChildNodes();
                int length = children.getLength();
                int i = 0;
                while (i < length) {
                    Node childNode = children.item(i);
                    if (!XmlFileMergerJaxp.isWhiteSpace(childNode)) {
                        if (childNode.getNodeType() != 8) break;
                        Comment comment = (Comment)childNode;
                        if (comment.getData().indexOf("@generated") != -1) {
                            rc = true;
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
        return rc;
    }

    private static boolean isWhiteSpace(Node node) {
        Text tn;
        boolean rc = false;
        if (node != null && node.getNodeType() == 3 && (tn = (Text)node).getData().trim().length() == 0) {
            rc = true;
        }
        return rc;
    }

    private static class NullEntityResolver
    implements EntityResolver {
        private NullEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            StringReader sr = new StringReader("");
            return new InputSource(sr);
        }
    }
}

