/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.api.dom.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.ibatis.ibator.api.dom.OutputUtilities;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.JavaElement;
import org.apache.ibatis.ibator.api.dom.java.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Method
extends JavaElement {
    private List<String> bodyLines = new ArrayList<String>();
    private boolean constructor;
    private FullyQualifiedJavaType returnType;
    private String name;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<FullyQualifiedJavaType> exceptions = new ArrayList<FullyQualifiedJavaType>();

    public List<String> getBodyLines() {
        return this.bodyLines;
    }

    public void addBodyLine(String line) {
        this.bodyLines.add(line);
    }

    public void addBodyLine(int index, String line) {
        this.bodyLines.add(index, line);
    }

    public void setBodyLine(int index, String line) {
        this.bodyLines.set(index, line);
    }

    public void removeBodyLine(int index) {
        this.bodyLines.remove(index);
    }

    public void addBodyLines(Collection<String> lines) {
        this.bodyLines.addAll(lines);
    }

    public void addBodyLines(int index, Collection<String> lines) {
        this.bodyLines.addAll(index, lines);
    }

    public String getFormattedContent(int indentLevel, boolean interfaceMethod) {
        StringBuilder sb = new StringBuilder();
        this.addFormattedJavadoc(sb, indentLevel);
        this.addFormattedAnnotations(sb, indentLevel);
        OutputUtilities.javaIndent(sb, indentLevel);
        sb.append(this.getVisibility().getValue());
        if (!interfaceMethod) {
            if (this.isStatic()) {
                sb.append("static ");
            }
            if (this.isFinal()) {
                sb.append("final ");
            }
            if (this.bodyLines.size() == 0) {
                sb.append("abstract ");
            }
        }
        if (!this.constructor) {
            if (this.getReturnType() == null) {
                sb.append("void");
            } else {
                sb.append(this.getReturnType().getShortName());
            }
            sb.append(' ');
        }
        sb.append(this.getName());
        sb.append('(');
        boolean comma = false;
        for (Parameter parameter : this.getParameters()) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(parameter.getFormattedContent());
        }
        sb.append(')');
        if (this.getExceptions().size() > 0) {
            sb.append(" throws ");
            comma = false;
            for (FullyQualifiedJavaType fqjt : this.getExceptions()) {
                if (comma) {
                    sb.append(", ");
                } else {
                    comma = true;
                }
                sb.append(fqjt.getShortName());
            }
        }
        if (this.bodyLines.size() == 0) {
            sb.append(';');
        } else {
            sb.append(" {");
            ++indentLevel;
            ListIterator<String> listIter = this.bodyLines.listIterator();
            while (listIter.hasNext()) {
                String line = listIter.next();
                if (line.startsWith("}")) {
                    --indentLevel;
                }
                OutputUtilities.newLine(sb);
                OutputUtilities.javaIndent(sb, indentLevel);
                sb.append(line);
                if (line.endsWith("{") && !line.startsWith("switch") || line.endsWith(":")) {
                    ++indentLevel;
                }
                if (!line.startsWith("break")) continue;
                if (listIter.hasNext()) {
                    String nextLine = listIter.next();
                    if (nextLine.startsWith("}")) {
                        ++indentLevel;
                    }
                    listIter.previous();
                }
                --indentLevel;
            }
            OutputUtilities.newLine(sb);
            OutputUtilities.javaIndent(sb, --indentLevel);
            sb.append('}');
        }
        return sb.toString();
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public void setConstructor(boolean constructor) {
        this.constructor = constructor;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public void addParameter(int index, Parameter parameter) {
        this.parameters.add(index, parameter);
    }

    public FullyQualifiedJavaType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(FullyQualifiedJavaType returnType) {
        this.returnType = returnType;
    }

    public List<FullyQualifiedJavaType> getExceptions() {
        return this.exceptions;
    }

    public void addException(FullyQualifiedJavaType exception) {
        this.exceptions.add(exception);
    }
}

