/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.Iterator;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.Constraint;
import net.sf.hibernate.mapping.Index;
import net.sf.hibernate.util.StringHelper;

public class UniqueKey
extends Constraint {
    public String sqlConstraintString(Dialect dialect) {
        StringBuffer buf = new StringBuffer("unique (");
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            buf.append(((Column)iter.next()).getQuotedName(dialect));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return buf.append(")").toString();
    }

    public String sqlConstraintString(Dialect dialect, String constraintName, String defaultSchema) {
        StringBuffer buf = new StringBuffer(dialect.getAddPrimaryKeyConstraintString(constraintName)).append('(');
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            buf.append(((Column)iter.next()).getQuotedName(dialect));
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        return StringHelper.replace(buf.append(")").toString(), "primary key", "unique");
    }

    public String sqlCreateString(Dialect dialect, Mapping p, String defaultSchema) {
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            return super.sqlCreateString(dialect, p, defaultSchema);
        }
        return Index.buildSqlCreateIndexString(dialect, this.getName(), this.getTable(), this.getColumnIterator(), true, defaultSchema);
    }

    public String sqlDropString(Dialect dialect, String defaultSchema) {
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            return super.sqlDropString(dialect, defaultSchema);
        }
        return Index.buildSqlDropIndexString(dialect, this.getTable(), this.getName(), defaultSchema);
    }
}

