/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.internal;

import java.io.File;
import java.util.StringTokenizer;
import org.apache.ibatis.ibator.api.ShellCallback;
import org.apache.ibatis.ibator.exception.ShellException;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

public class DefaultShellCallback
implements ShellCallback {
    private boolean overwrite;

    public DefaultShellCallback(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public File getDirectory(String targetProject, String targetPackage) throws ShellException {
        boolean rc;
        File project = new File(targetProject);
        if (!project.isDirectory()) {
            throw new ShellException(Messages.getString("Warning.9", targetProject));
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(targetPackage, ".");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(File.separatorChar);
        }
        File directory = new File(project, sb.toString());
        if (!directory.isDirectory() && !(rc = directory.mkdirs())) {
            throw new ShellException(Messages.getString("Warning.10", directory.getAbsolutePath()));
        }
        return directory;
    }

    public void refreshProject(String project) {
    }

    public boolean isMergeSupported() {
        return false;
    }

    public boolean isOverwriteEnabled() {
        return this.overwrite;
    }

    public String mergeJavaFile(String newFileSource, String existingFileFullPath, String[] javadocTags) throws ShellException {
        throw new UnsupportedOperationException();
    }
}

