/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis2.dao;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.ibator.api.CommentGenerator;
import org.apache.ibatis.ibator.api.FullyQualifiedTable;
import org.apache.ibatis.ibator.api.dom.java.CompilationUnit;
import org.apache.ibatis.ibator.api.dom.java.Field;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.Interface;
import org.apache.ibatis.ibator.api.dom.java.JavaVisibility;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.api.dom.java.TopLevelClass;
import org.apache.ibatis.ibator.generator.AbstractJavaGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.AbstractDAOElementGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.CountByExampleMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.DeleteByExampleMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.DeleteByPrimaryKeyMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.InsertMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.InsertSelectiveMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.SelectByExampleWithBLOBsMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.SelectByExampleWithoutBLOBsMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.SelectByPrimaryKeyMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.UpdateByExampleParmsInnerclassGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.UpdateByExampleSelectiveMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.UpdateByExampleWithBLOBsMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.UpdateByExampleWithoutBLOBsMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.UpdateByPrimaryKeySelectiveMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.UpdateByPrimaryKeyWithBLOBsMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.elements.UpdateByPrimaryKeyWithoutBLOBsMethodGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.dao.templates.AbstractDAOTemplate;
import org.apache.ibatis.ibator.internal.rules.IbatorRules;
import org.apache.ibatis.ibator.internal.util.StringUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAOGenerator
extends AbstractJavaGenerator {
    private AbstractDAOTemplate daoTemplate;
    private boolean generateForJava5;

    public DAOGenerator(AbstractDAOTemplate daoTemplate, boolean generateForJava5) {
        this.daoTemplate = daoTemplate;
        this.generateForJava5 = generateForJava5;
    }

    @Override
    public List<CompilationUnit> getCompilationUnits() {
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        this.progressCallback.startTask(Messages.getString("Progress.14", table.toString()));
        TopLevelClass topLevelClass = this.getTopLevelClassShell();
        Interface interfaze = this.getInterfaceShell();
        this.addCountByExampleMethod(topLevelClass, interfaze);
        this.addDeleteByExampleMethod(topLevelClass, interfaze);
        this.addDeleteByPrimaryKeyMethod(topLevelClass, interfaze);
        this.addInsertMethod(topLevelClass, interfaze);
        this.addInsertSelectiveMethod(topLevelClass, interfaze);
        this.addSelectByExampleWithBLOBsMethod(topLevelClass, interfaze);
        this.addSelectByExampleWithoutBLOBsMethod(topLevelClass, interfaze);
        this.addSelectByPrimaryKeyMethod(topLevelClass, interfaze);
        this.addUpdateByExampleParmsInnerclass(topLevelClass, interfaze);
        this.addUpdateByExampleSelectiveMethod(topLevelClass, interfaze);
        this.addUpdateByExampleWithBLOBsMethod(topLevelClass, interfaze);
        this.addUpdateByExampleWithoutBLOBsMethod(topLevelClass, interfaze);
        this.addUpdateByPrimaryKeySelectiveMethod(topLevelClass, interfaze);
        this.addUpdateByPrimaryKeyWithBLOBsMethod(topLevelClass, interfaze);
        this.addUpdateByPrimaryKeyWithoutBLOBsMethod(topLevelClass, interfaze);
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        if (this.ibatorContext.getPlugins().daoImplementationGenerated(topLevelClass, this.introspectedTable)) {
            answer.add(topLevelClass);
        }
        if (this.ibatorContext.getPlugins().daoInterfaceGenerated(interfaze, this.introspectedTable)) {
            answer.add(interfaze);
        }
        return answer;
    }

    protected TopLevelClass getTopLevelClassShell() {
        FullyQualifiedJavaType interfaceType = new FullyQualifiedJavaType(this.introspectedTable.getDAOInterfaceType());
        FullyQualifiedJavaType implementationType = new FullyQualifiedJavaType(this.introspectedTable.getDAOImplementationType());
        CommentGenerator commentGenerator = this.ibatorContext.getCommentGenerator();
        TopLevelClass answer = new TopLevelClass(implementationType);
        answer.setVisibility(JavaVisibility.PUBLIC);
        answer.setSuperClass(this.daoTemplate.getSuperClass());
        answer.addImportedType(this.daoTemplate.getSuperClass());
        answer.addSuperInterface(interfaceType);
        answer.addImportedType(interfaceType);
        for (FullyQualifiedJavaType fqjt : this.daoTemplate.getImplementationImports()) {
            answer.addImportedType(fqjt);
        }
        commentGenerator.addJavaFileComment(answer);
        answer.addMethod(this.daoTemplate.getConstructorClone(commentGenerator, implementationType, this.introspectedTable));
        for (Field field : this.daoTemplate.getFieldClones(commentGenerator, this.introspectedTable)) {
            answer.addField(field);
        }
        for (Method method : this.daoTemplate.getMethodClones(commentGenerator, this.introspectedTable)) {
            answer.addMethod(method);
        }
        return answer;
    }

    protected Interface getInterfaceShell() {
        Interface answer = new Interface(new FullyQualifiedJavaType(this.introspectedTable.getDAOInterfaceType()));
        answer.setVisibility(JavaVisibility.PUBLIC);
        String rootInterface = this.introspectedTable.getTableConfigurationProperty("rootInterface");
        if (rootInterface == null) {
            rootInterface = this.ibatorContext.getDaoGeneratorConfiguration().getProperty("rootInterface");
        }
        if (StringUtility.stringHasValue(rootInterface)) {
            FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(rootInterface);
            answer.addSuperInterface(fqjt);
            answer.addImportedType(fqjt);
        }
        for (FullyQualifiedJavaType fqjt : this.daoTemplate.getInterfaceImports()) {
            answer.addImportedType(fqjt);
        }
        this.ibatorContext.getCommentGenerator().addJavaFileComment(answer);
        return answer;
    }

    protected void addCountByExampleMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateCountByExample()) {
            CountByExampleMethodGenerator methodGenerator = new CountByExampleMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addDeleteByExampleMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateDeleteByExample()) {
            DeleteByExampleMethodGenerator methodGenerator = new DeleteByExampleMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addDeleteByPrimaryKeyMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateDeleteByPrimaryKey()) {
            DeleteByPrimaryKeyMethodGenerator methodGenerator = new DeleteByPrimaryKeyMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addInsertMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateInsert()) {
            InsertMethodGenerator methodGenerator = new InsertMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addInsertSelectiveMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateInsertSelective()) {
            InsertSelectiveMethodGenerator methodGenerator = new InsertSelectiveMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addSelectByExampleWithBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateSelectByExampleWithBLOBs()) {
            SelectByExampleWithBLOBsMethodGenerator methodGenerator = new SelectByExampleWithBLOBsMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addSelectByExampleWithoutBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateSelectByExampleWithoutBLOBs()) {
            SelectByExampleWithoutBLOBsMethodGenerator methodGenerator = new SelectByExampleWithoutBLOBsMethodGenerator(this.generateForJava5);
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addSelectByPrimaryKeyMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateSelectByPrimaryKey()) {
            SelectByPrimaryKeyMethodGenerator methodGenerator = new SelectByPrimaryKeyMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByExampleParmsInnerclass(TopLevelClass topLevelClass, Interface interfaze) {
        IbatorRules ibatorRules = this.introspectedTable.getRules();
        if (ibatorRules.generateUpdateByExampleSelective() || ibatorRules.generateUpdateByExampleWithBLOBs() || ibatorRules.generateUpdateByExampleWithoutBLOBs()) {
            UpdateByExampleParmsInnerclassGenerator methodGenerator = new UpdateByExampleParmsInnerclassGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByExampleSelectiveMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByExampleSelective()) {
            UpdateByExampleSelectiveMethodGenerator methodGenerator = new UpdateByExampleSelectiveMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByExampleWithBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByExampleWithBLOBs()) {
            UpdateByExampleWithBLOBsMethodGenerator methodGenerator = new UpdateByExampleWithBLOBsMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByExampleWithoutBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByExampleWithoutBLOBs()) {
            UpdateByExampleWithoutBLOBsMethodGenerator methodGenerator = new UpdateByExampleWithoutBLOBsMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByPrimaryKeySelectiveMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByPrimaryKeySelective()) {
            UpdateByPrimaryKeySelectiveMethodGenerator methodGenerator = new UpdateByPrimaryKeySelectiveMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByPrimaryKeyWithBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByPrimaryKeyWithBLOBs()) {
            UpdateByPrimaryKeyWithBLOBsMethodGenerator methodGenerator = new UpdateByPrimaryKeyWithBLOBsMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void addUpdateByPrimaryKeyWithoutBLOBsMethod(TopLevelClass topLevelClass, Interface interfaze) {
        if (this.introspectedTable.getRules().generateUpdateByPrimaryKeyWithoutBLOBs()) {
            UpdateByPrimaryKeyWithoutBLOBsMethodGenerator methodGenerator = new UpdateByPrimaryKeyWithoutBLOBsMethodGenerator();
            this.initializeAndExecuteGenerator(methodGenerator, topLevelClass, interfaze);
        }
    }

    protected void initializeAndExecuteGenerator(AbstractDAOElementGenerator methodGenerator, TopLevelClass topLevelClass, Interface interfaze) {
        methodGenerator.setDAOTemplate(this.daoTemplate);
        methodGenerator.setIbatorContext(this.ibatorContext);
        methodGenerator.setIntrospectedTable(this.introspectedTable);
        methodGenerator.setProgressCallback(this.progressCallback);
        methodGenerator.setWarnings(this.warnings);
        methodGenerator.addImplementationElements(topLevelClass);
        methodGenerator.addInterfaceElements(interfaze);
    }
}

