/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.Document;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.config.IbatorContext;
import org.apache.ibatis.ibator.exception.InvalidConfigurationException;
import org.apache.ibatis.ibator.internal.util.StringUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IbatorConfiguration {
    private List<IbatorContext> ibatorContexts = new ArrayList<IbatorContext>();
    private List<String> classPathEntries = new ArrayList<String>();

    public void addClasspathEntry(String entry) {
        this.classPathEntries.add(entry);
    }

    public List<String> getClassPathEntries() {
        return this.classPathEntries;
    }

    public void validate() throws InvalidConfigurationException {
        ArrayList<String> errors = new ArrayList<String>();
        for (String classPathEntry : this.classPathEntries) {
            if (StringUtility.stringHasValue(classPathEntry)) continue;
            errors.add(Messages.getString("ValidationError.19"));
            break;
        }
        if (this.ibatorContexts.size() == 0) {
            errors.add(Messages.getString("ValidationError.11"));
        } else {
            for (IbatorContext ibatorContext : this.ibatorContexts) {
                ibatorContext.validate(errors);
            }
        }
        if (errors.size() > 0) {
            throw new InvalidConfigurationException(errors);
        }
    }

    public List<IbatorContext> getIbatorContexts() {
        return this.ibatorContexts;
    }

    public void addIbatorContext(IbatorContext ibatorContext) {
        this.ibatorContexts.add(ibatorContext);
    }

    public IbatorContext getIbatorContext(String id) {
        for (IbatorContext ibatorContext : this.ibatorContexts) {
            if (!id.equals(ibatorContext.getId())) continue;
            return ibatorContext;
        }
        return null;
    }

    public Document toDocument() {
        Document document = new Document("-//Apache Software Foundation//DTD Apache iBATIS Ibator Configuration 1.0//EN", "http://ibatis.apache.org/dtd/ibator-config_1_0.dtd");
        XmlElement rootElement = new XmlElement("ibatorConfiguration");
        document.setRootElement(rootElement);
        for (String classPathEntry : this.classPathEntries) {
            XmlElement cpeElement = new XmlElement("classPathEntry");
            cpeElement.addAttribute(new Attribute("location", classPathEntry));
            rootElement.addElement(cpeElement);
        }
        for (IbatorContext ibatorContext : this.ibatorContexts) {
            rootElement.addElement(ibatorContext.toXmlElement());
        }
        return document;
    }
}

