/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.ibator.api.GeneratedJavaFile;
import org.apache.ibatis.ibator.api.GeneratedXmlFile;
import org.apache.ibatis.ibator.api.ProgressCallback;
import org.apache.ibatis.ibator.api.ShellCallback;
import org.apache.ibatis.ibator.config.IbatorConfiguration;
import org.apache.ibatis.ibator.config.IbatorContext;
import org.apache.ibatis.ibator.config.MergeConstants;
import org.apache.ibatis.ibator.exception.InvalidConfigurationException;
import org.apache.ibatis.ibator.exception.ShellException;
import org.apache.ibatis.ibator.internal.DefaultShellCallback;
import org.apache.ibatis.ibator.internal.IbatorObjectFactory;
import org.apache.ibatis.ibator.internal.NullProgressCallback;
import org.apache.ibatis.ibator.internal.util.ClassloaderUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ibator {
    private IbatorConfiguration ibatorConfiguration;
    private ShellCallback shellCallback;
    private List<GeneratedJavaFile> generatedJavaFiles;
    private List<GeneratedXmlFile> generatedXmlFiles;
    private List<String> warnings;
    private Set<String> projects;

    public Ibator(IbatorConfiguration ibatorConfiguration, ShellCallback shellCallback, List<String> warnings) throws InvalidConfigurationException {
        if (ibatorConfiguration == null) {
            throw new IllegalArgumentException(Messages.getString("RuntimeError.2"));
        }
        this.ibatorConfiguration = ibatorConfiguration;
        this.shellCallback = shellCallback == null ? new DefaultShellCallback(false) : shellCallback;
        this.warnings = warnings == null ? new ArrayList<String>() : warnings;
        this.generatedJavaFiles = new ArrayList<GeneratedJavaFile>();
        this.generatedXmlFiles = new ArrayList<GeneratedXmlFile>();
        this.projects = new HashSet<String>();
        this.ibatorConfiguration.validate();
    }

    public void generate(ProgressCallback callback) throws SQLException, IOException, InterruptedException {
        this.generate(callback, null, null);
    }

    public void generate(ProgressCallback callback, Set<String> contextIds) throws SQLException, IOException, InterruptedException {
        this.generate(callback, contextIds, null);
    }

    public void generate(ProgressCallback callback, Set<String> contextIds, Set<String> fullyQualifiedTableNames) throws SQLException, IOException, InterruptedException {
        String source;
        File targetFile;
        File directory;
        List<IbatorContext> contextsToRun;
        if (callback == null) {
            callback = new NullProgressCallback();
        }
        this.generatedJavaFiles.clear();
        this.generatedXmlFiles.clear();
        if (contextIds == null || contextIds.size() == 0) {
            contextsToRun = this.ibatorConfiguration.getIbatorContexts();
        } else {
            contextsToRun = new ArrayList<IbatorContext>();
            for (IbatorContext ibatorContext : this.ibatorConfiguration.getIbatorContexts()) {
                if (!contextIds.contains(ibatorContext.getId())) continue;
                contextsToRun.add(ibatorContext);
            }
        }
        if (this.ibatorConfiguration.getClassPathEntries().size() > 0) {
            ClassLoader classLoader = ClassloaderUtility.getCustomClassloader(this.ibatorConfiguration.getClassPathEntries());
            IbatorObjectFactory.setExternalClassLoader(classLoader);
        }
        int totalSteps = 0;
        for (IbatorContext ibatorContext : contextsToRun) {
            totalSteps += ibatorContext.getIntrospectionSteps();
        }
        callback.introspectionStarted(totalSteps);
        for (IbatorContext ibatorContext : contextsToRun) {
            ibatorContext.introspectTables(callback, this.warnings, fullyQualifiedTableNames);
        }
        totalSteps = 0;
        for (IbatorContext ibatorContext : contextsToRun) {
            totalSteps += ibatorContext.getGenerationSteps();
        }
        callback.generationStarted(totalSteps);
        for (IbatorContext ibatorContext : contextsToRun) {
            ibatorContext.generateFiles(callback, this.generatedJavaFiles, this.generatedXmlFiles, this.warnings);
        }
        callback.saveStarted(this.generatedXmlFiles.size() + this.generatedJavaFiles.size());
        for (GeneratedXmlFile gxf : this.generatedXmlFiles) {
            this.projects.add(gxf.getTargetProject());
            try {
                directory = this.shellCallback.getDirectory(gxf.getTargetProject(), gxf.getTargetPackage());
                targetFile = new File(directory, gxf.getFileName());
                source = gxf.getFormattedContent();
            }
            catch (ShellException e) {
                this.warnings.add(e.getMessage());
                continue;
            }
            callback.checkCancel();
            callback.startTask(Messages.getString("Progress.15", targetFile.getName()));
            this.writeFile(targetFile, source);
        }
        for (GeneratedJavaFile gjf : this.generatedJavaFiles) {
            this.projects.add(gjf.getTargetProject());
            try {
                directory = this.shellCallback.getDirectory(gjf.getTargetProject(), gjf.getTargetPackage());
                targetFile = new File(directory, gjf.getFileName());
                if (targetFile.exists()) {
                    if (this.shellCallback.isMergeSupported()) {
                        source = this.shellCallback.mergeJavaFile(gjf.getFormattedContent(), targetFile.getAbsolutePath(), MergeConstants.OLD_JAVA_ELEMENT_TAGS);
                    } else if (this.shellCallback.isOverwriteEnabled()) {
                        source = gjf.getFormattedContent();
                        this.warnings.add(Messages.getString("Warning.11", targetFile.getAbsolutePath()));
                    } else {
                        source = gjf.getFormattedContent();
                        targetFile = this.getUniqueFileName(directory, gjf.getFileName());
                        this.warnings.add(Messages.getString("Warning.2", targetFile.getAbsolutePath()));
                    }
                } else {
                    source = gjf.getFormattedContent();
                }
                callback.checkCancel();
                callback.startTask(Messages.getString("Progress.15", targetFile.getName()));
                this.writeFile(targetFile, source);
            }
            catch (ShellException e) {
                this.warnings.add(e.getMessage());
            }
        }
        for (String project : this.projects) {
            this.shellCallback.refreshProject(project);
        }
        callback.done();
    }

    private void writeFile(File file, String content) throws IOException {
        OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        fos.write(content);
        fos.flush();
        fos.close();
    }

    private File getUniqueFileName(File directory, String fileName) {
        File answer = null;
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i < 1000) {
            sb.setLength(0);
            sb.append(fileName);
            sb.append('.');
            sb.append(i);
            File testFile = new File(directory, sb.toString());
            if (!testFile.exists()) {
                answer = testFile;
                break;
            }
            ++i;
        }
        if (answer == null) {
            throw new RuntimeException(Messages.getString("RuntimeError.3", directory.getAbsolutePath()));
        }
        return answer;
    }
}

