/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis3.xmlmapper.elements;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.dom.OutputUtilities;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.TextElement;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.config.GeneratedKey;
import org.apache.ibatis.ibator.config.JDBCConnectionConfiguration;
import org.apache.ibatis.ibator.generator.ibatis3.Ibatis3FormattingUtilities;
import org.apache.ibatis.ibator.generator.ibatis3.xmlmapper.elements.AbstractXmlElementGenerator;

public class InsertElementGenerator
extends AbstractXmlElementGenerator {
    public void addElements(XmlElement parentElement) {
        if (JDBCConnectionConfiguration.dbType.toLowerCase().indexOf(".db2") > 0) {
            IntrospectedColumn introspectedColumn3;
            IntrospectedColumn introspectedColumn2;
            XmlElement answer = new XmlElement("insert");
            answer.addAttribute(new Attribute("id", this.introspectedTable.getInsertStatementId()));
            FullyQualifiedJavaType parameterType = this.introspectedTable.getRules().calculateAllFieldsClass();
            answer.addAttribute(new Attribute("parameterType", parameterType.getFullyQualifiedName()));
            this.ibatorContext.getCommentGenerator().addComment(answer);
            GeneratedKey gk = this.introspectedTable.getGeneratedKey();
            String sequenceColumn = null;
            if (gk != null && gk.isBeforeInsert() && (introspectedColumn2 = this.introspectedTable.getColumn(gk.getColumn())) != null) {
                answer.addElement(this.getSelectKey(introspectedColumn2, gk));
                sequenceColumn = gk.getColumn();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ");
            sb.append(this.introspectedTable.getFullyQualifiedTableNameAtRuntime());
            answer.addElement(new TextElement(sb.toString()));
            XmlElement insertTrimElement = new XmlElement("trim");
            insertTrimElement.addAttribute(new Attribute("prefix", "("));
            insertTrimElement.addAttribute(new Attribute("suffix", ")"));
            insertTrimElement.addAttribute(new Attribute("suffixOverrides", ","));
            answer.addElement(insertTrimElement);
            XmlElement valuesTrimElement = new XmlElement("trim");
            valuesTrimElement.addAttribute(new Attribute("prefix", "values ("));
            valuesTrimElement.addAttribute(new Attribute("suffix", ")"));
            valuesTrimElement.addAttribute(new Attribute("suffixOverrides", ","));
            answer.addElement(valuesTrimElement);
            for (IntrospectedColumn introspectedColumn3 : this.introspectedTable.getAllColumns()) {
                boolean isSequenceColumn;
                if (introspectedColumn3.isIdentity()) continue;
                boolean bl = isSequenceColumn = sequenceColumn == null ? false : sequenceColumn.equals(introspectedColumn3.getActualColumnName());
                if (isSequenceColumn) {
                    sb.setLength(0);
                    sb.append(Ibatis3FormattingUtilities.getEscapedColumnName(introspectedColumn3));
                    sb.append(',');
                    insertTrimElement.addElement(new TextElement(sb.toString()));
                    sb.setLength(0);
                    sb.append(Ibatis3FormattingUtilities.getParameterClause(introspectedColumn3));
                    sb.append(',');
                    valuesTrimElement.addElement(new TextElement(sb.toString()));
                    continue;
                }
                XmlElement insertNotNullElement = new XmlElement("if");
                sb.setLength(0);
                sb.append(introspectedColumn3.getJavaProperty());
                sb.append(" != null");
                insertNotNullElement.addAttribute(new Attribute("test", sb.toString()));
                sb.setLength(0);
                sb.append(Ibatis3FormattingUtilities.getEscapedColumnName(introspectedColumn3));
                sb.append(',');
                insertNotNullElement.addElement(new TextElement(sb.toString()));
                insertTrimElement.addElement(insertNotNullElement);
                XmlElement valuesNotNullElement = new XmlElement("if");
                sb.setLength(0);
                sb.append(introspectedColumn3.getJavaProperty());
                sb.append(" != null");
                valuesNotNullElement.addAttribute(new Attribute("test", sb.toString()));
                sb.setLength(0);
                sb.append(Ibatis3FormattingUtilities.getParameterClause(introspectedColumn3));
                sb.append(',');
                valuesNotNullElement.addElement(new TextElement(sb.toString()));
                valuesTrimElement.addElement(valuesNotNullElement);
            }
            if (gk != null && !gk.isBeforeInsert() && (introspectedColumn3 = this.introspectedTable.getColumn(gk.getColumn())) != null) {
                answer.addElement(this.getSelectKey(introspectedColumn3, gk));
            }
            if (this.ibatorContext.getPlugins().sqlMapInsertSelectiveElementGenerated(answer, this.introspectedTable)) {
                parentElement.addElement(answer);
            }
        } else {
            IntrospectedColumn introspectedColumn;
            IntrospectedColumn introspectedColumn4;
            XmlElement answer = new XmlElement("insert");
            answer.addAttribute(new Attribute("id", this.introspectedTable.getInsertStatementId()));
            FullyQualifiedJavaType parameterType = this.introspectedTable.getRules().calculateAllFieldsClass();
            answer.addAttribute(new Attribute("parameterType", parameterType.getFullyQualifiedName()));
            this.ibatorContext.getCommentGenerator().addComment(answer);
            GeneratedKey gk = this.introspectedTable.getGeneratedKey();
            if (gk != null && gk.isBeforeInsert() && (introspectedColumn4 = this.introspectedTable.getColumn(gk.getColumn())) != null) {
                answer.addElement(this.getSelectKey(introspectedColumn4, gk));
            }
            StringBuilder insertClause = new StringBuilder();
            StringBuilder valuesClause = new StringBuilder();
            insertClause.append("insert into ");
            insertClause.append(this.introspectedTable.getFullyQualifiedTableNameAtRuntime());
            insertClause.append(" (");
            valuesClause.append("values (");
            ArrayList<String> valuesClauses = new ArrayList<String>();
            Iterator<IntrospectedColumn> iter = this.introspectedTable.getAllColumns().iterator();
            while (iter.hasNext()) {
                introspectedColumn = iter.next();
                if (introspectedColumn.isIdentity()) continue;
                insertClause.append(Ibatis3FormattingUtilities.getEscapedColumnName(introspectedColumn));
                valuesClause.append(Ibatis3FormattingUtilities.getParameterClause(introspectedColumn));
                if (iter.hasNext()) {
                    insertClause.append(", ");
                    valuesClause.append(", ");
                }
                if (valuesClause.length() <= 80) continue;
                answer.addElement(new TextElement(insertClause.toString()));
                insertClause.setLength(0);
                OutputUtilities.xmlIndent(insertClause, 1);
                valuesClauses.add(valuesClause.toString());
                valuesClause.setLength(0);
                OutputUtilities.xmlIndent(valuesClause, 1);
            }
            insertClause.append(')');
            answer.addElement(new TextElement(insertClause.toString()));
            valuesClause.append(')');
            valuesClauses.add(valuesClause.toString());
            for (String clause : valuesClauses) {
                answer.addElement(new TextElement(clause));
            }
            if (gk != null && !gk.isBeforeInsert() && (introspectedColumn = this.introspectedTable.getColumn(gk.getColumn())) != null) {
                answer.addElement(this.getSelectKey(introspectedColumn, gk));
            }
            if (this.ibatorContext.getPlugins().sqlMapInsertElementGenerated(answer, this.introspectedTable)) {
                parentElement.addElement(answer);
            }
        }
    }
}

