/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.api.dom;

import java.util.Set;
import java.util.TreeSet;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputUtilities {
    private static final String lineSeparator;

    static {
        String ls = System.getProperty("line.separator");
        if (ls == null) {
            ls = "\n";
        }
        lineSeparator = ls;
    }

    private OutputUtilities() {
    }

    public static void javaIndent(StringBuilder sb, int indentLevel) {
        int i = 0;
        while (i < indentLevel) {
            sb.append("    ");
            ++i;
        }
    }

    public static void xmlIndent(StringBuilder sb, int indentLevel) {
        int i = 0;
        while (i < indentLevel) {
            sb.append("  ");
            ++i;
        }
    }

    public static void newLine(StringBuilder sb) {
        sb.append(lineSeparator);
    }

    public static Set<String> calculateImports(Set<FullyQualifiedJavaType> importedTypes) {
        StringBuilder sb = new StringBuilder();
        TreeSet<String> importStrings = new TreeSet<String>();
        for (FullyQualifiedJavaType fqjt : importedTypes) {
            for (String importString : fqjt.getImportList()) {
                sb.setLength(0);
                sb.append("import ");
                sb.append(importString);
                sb.append(';');
                importStrings.add(sb.toString());
            }
        }
        return importStrings;
    }
}

