/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.collection.AbstractCollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.impl.MessageHelper;
import net.sf.hibernate.loader.BatchingCollectionInitializer;
import net.sf.hibernate.loader.CollectionInitializer;
import net.sf.hibernate.loader.OneToManyLoader;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.persister.Joinable;
import net.sf.hibernate.persister.OuterJoinLoadable;
import net.sf.hibernate.sql.Update;
import net.sf.hibernate.util.ArrayHelper;

public class OneToManyPersister
extends AbstractCollectionPersister {
    public OneToManyPersister(Collection collection, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        super(collection, cfg, factory);
    }

    protected String generateDeleteString() {
        Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null").setPrimaryKeyColumnNames(this.keyColumnNames);
        if (this.hasIndex) {
            update.addColumns(this.indexColumnNames, "null");
        }
        if (this.hasWhere) {
            update.setWhere(this.sqlWhereString);
        }
        return update.toStatementString();
    }

    protected String generateInsertRowString() {
        Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIndex) {
            update.addColumns(this.indexColumnNames);
        }
        return update.setPrimaryKeyColumnNames(this.elementColumnNames).toStatementString();
    }

    protected String generateUpdateRowString() {
        return null;
    }

    protected String generateDeleteRowString() {
        String[] pkColumns = this.hasIdentifier ? this.rowSelectColumnNames : ArrayHelper.join(this.keyColumnNames, this.rowSelectColumnNames);
        Update update = new Update().setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames, "null");
        if (this.hasIndex) {
            update.addColumns(this.indexColumnNames, "null");
        }
        return update.setPrimaryKeyColumnNames(pkColumns).toStatementString();
    }

    public boolean consumesAlias() {
        return true;
    }

    public boolean isOneToMany() {
        return true;
    }

    public boolean isManyToMany() {
        return false;
    }

    protected int doUpdateRows(Serializable id, PersistentCollection collection, SessionImplementor session) throws HibernateException {
        try {
            Object entry;
            Iterator entries;
            int i;
            PreparedStatement st;
            int count = 0;
            try {
                st = null;
                i = 0;
                entries = collection.entries();
                while (entries.hasNext()) {
                    entry = entries.next();
                    if (collection.needsUpdating(entry, i, this.elementType)) {
                        if (st == null) {
                            st = session.getBatcher().prepareBatchStatement(this.getSQLDeleteRowString());
                        }
                        this.writeKey(st, id, false, session);
                        this.writeIndex(st, collection.getIndex(entry, i), false, session);
                        session.getBatcher().addToBatch(-1);
                        ++count;
                    }
                    ++i;
                }
            }
            catch (SQLException sqle) {
                session.getBatcher().abortBatch(sqle);
                throw sqle;
            }
            try {
                st = null;
                i = 0;
                entries = collection.entries();
                while (entries.hasNext()) {
                    entry = entries.next();
                    if (collection.needsUpdating(entry, i, this.elementType)) {
                        if (st == null) {
                            st = session.getBatcher().prepareBatchStatement(this.getSQLInsertRowString());
                        }
                        this.writeKey(st, id, false, session);
                        collection.writeTo(st, this, entry, i, false);
                        session.getBatcher().addToBatch(1);
                        ++count;
                    }
                    ++i;
                }
            }
            catch (SQLException sqle) {
                session.getBatcher().abortBatch(sqle);
                throw sqle;
            }
            return count;
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "could not update collection rows: " + MessageHelper.infoString(this, id));
        }
    }

    public String selectFragment(String alias, String suffix, boolean includeCollectionColumns) {
        OuterJoinLoadable ojl = (OuterJoinLoadable)this.getElementPersister();
        StringBuffer buf = new StringBuffer();
        if (includeCollectionColumns) {
            buf.append(this.selectFragment(alias)).append(", ");
        }
        return buf.append(ojl.selectFragment(alias, suffix)).toString();
    }

    protected CollectionInitializer createCollectionInitializer(SessionFactoryImplementor factory) throws MappingException {
        OneToManyLoader nonbatchLoader = new OneToManyLoader(this, factory);
        if (this.batchSize > 1) {
            OneToManyLoader batchLoader = new OneToManyLoader(this, this.batchSize, factory);
            int smallBatchSize = (int)Math.round(Math.sqrt(this.batchSize));
            OneToManyLoader smallBatchLoader = new OneToManyLoader(this, smallBatchSize, factory);
            return new BatchingCollectionInitializer(this, this.batchSize, batchLoader, smallBatchSize, smallBatchLoader, nonbatchLoader);
        }
        return nonbatchLoader;
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return ((Joinable)((Object)this.getElementPersister())).fromJoinFragment(alias, innerJoin, includeSubclasses);
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return ((Joinable)((Object)this.getElementPersister())).whereJoinFragment(alias, innerJoin, includeSubclasses);
    }
}

