/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis3;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.ibator.api.GeneratedJavaFile;
import org.apache.ibatis.ibator.api.GeneratedXmlFile;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.ProgressCallback;
import org.apache.ibatis.ibator.api.dom.java.CompilationUnit;
import org.apache.ibatis.ibator.api.dom.xml.Document;
import org.apache.ibatis.ibator.generator.AbstractGenerator;
import org.apache.ibatis.ibator.generator.AbstractJavaGenerator;
import org.apache.ibatis.ibator.generator.AbstractXmlGenerator;
import org.apache.ibatis.ibator.generator.ibatis3.javamapper.JavaMapperGenerator;
import org.apache.ibatis.ibator.generator.ibatis3.model.BaseRecordGenerator;
import org.apache.ibatis.ibator.generator.ibatis3.model.ExampleGenerator;
import org.apache.ibatis.ibator.generator.ibatis3.model.PrimaryKeyGenerator;
import org.apache.ibatis.ibator.generator.ibatis3.model.RecordWithBLOBsGenerator;
import org.apache.ibatis.ibator.generator.ibatis3.xmlmapper.XMLMapperGenerator;
import org.apache.ibatis.ibator.internal.IbatorObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectedTableIbatis3Impl
extends IntrospectedTable {
    protected List<AbstractJavaGenerator> javaModelGenerators = new ArrayList<AbstractJavaGenerator>();
    protected List<AbstractJavaGenerator> daoGenerators = new ArrayList<AbstractJavaGenerator>();
    protected AbstractXmlGenerator xmlMapperGenerator;

    public IntrospectedTableIbatis3Impl() {
        super(IntrospectedTable.TargetRuntime.IBATIS3);
    }

    @Override
    public void calculateGenerators(List<String> warnings, ProgressCallback progressCallback) {
        this.calculateJavaModelGenerators(warnings, progressCallback);
        this.calculateDAOGenerators(warnings, progressCallback);
        this.calculateXmlMapperGenerator(warnings, progressCallback);
    }

    protected void calculateXmlMapperGenerator(List<String> warnings, ProgressCallback progressCallback) {
        this.xmlMapperGenerator = new XMLMapperGenerator();
        this.initializeAbstractGenerator(this.xmlMapperGenerator, warnings, progressCallback);
    }

    protected void calculateDAOGenerators(List<String> warnings, ProgressCallback progressCallback) {
        if (this.ibatorContext.getDaoGeneratorConfiguration() == null) {
            return;
        }
        String type = this.ibatorContext.getDaoGeneratorConfiguration().getConfigurationType();
        AbstractJavaGenerator javaGenerator = "MAPPER".equalsIgnoreCase(type) ? new JavaMapperGenerator() : (AbstractJavaGenerator)IbatorObjectFactory.createInternalObject(type);
        this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
        this.daoGenerators.add(javaGenerator);
    }

    protected void calculateJavaModelGenerators(List<String> warnings, ProgressCallback progressCallback) {
        AbstractJavaGenerator javaGenerator;
        if (this.getRules().generateExampleClass()) {
            javaGenerator = new ExampleGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
        if (this.getRules().generatePrimaryKeyClass()) {
            javaGenerator = new PrimaryKeyGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
        if (this.getRules().generateBaseRecordClass()) {
            javaGenerator = new BaseRecordGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
        if (this.getRules().generateRecordWithBLOBsClass()) {
            javaGenerator = new RecordWithBLOBsGenerator();
            this.initializeAbstractGenerator(javaGenerator, warnings, progressCallback);
            this.javaModelGenerators.add(javaGenerator);
        }
    }

    protected void initializeAbstractGenerator(AbstractGenerator abstractGenerator, List<String> warnings, ProgressCallback progressCallback) {
        abstractGenerator.setIbatorContext(this.ibatorContext);
        abstractGenerator.setIntrospectedTable(this);
        abstractGenerator.setProgressCallback(progressCallback);
        abstractGenerator.setWarnings(warnings);
    }

    @Override
    public List<GeneratedJavaFile> getGeneratedJavaFiles() {
        GeneratedJavaFile gjf;
        List<CompilationUnit> compilationUnits;
        ArrayList<GeneratedJavaFile> answer = new ArrayList<GeneratedJavaFile>();
        for (AbstractJavaGenerator javaGenerator : this.javaModelGenerators) {
            compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                gjf = new GeneratedJavaFile(compilationUnit, this.ibatorContext.getJavaModelGeneratorConfiguration().getTargetProject());
                answer.add(gjf);
            }
        }
        for (AbstractJavaGenerator javaGenerator : this.daoGenerators) {
            compilationUnits = javaGenerator.getCompilationUnits();
            for (CompilationUnit compilationUnit : compilationUnits) {
                gjf = new GeneratedJavaFile(compilationUnit, this.ibatorContext.getDaoGeneratorConfiguration().getTargetProject());
                answer.add(gjf);
            }
        }
        return answer;
    }

    @Override
    public List<GeneratedXmlFile> getGeneratedXmlFiles() {
        ArrayList<GeneratedXmlFile> answer = new ArrayList<GeneratedXmlFile>();
        Document document = this.xmlMapperGenerator.getDocument();
        GeneratedXmlFile gxf = new GeneratedXmlFile(document, this.getIbatis3XmlMapperFileName(), this.getIbatis3XmlMapperPackage(), this.ibatorContext.getSqlMapGeneratorConfiguration().getTargetProject(), true);
        if (this.ibatorContext.getPlugins().sqlMapGenerated(gxf, this)) {
            answer.add(gxf);
        }
        return answer;
    }

    @Override
    public int getGenerationSteps() {
        return this.javaModelGenerators.size() + this.daoGenerators.size() + 1;
    }

    @Override
    public boolean isJava5Targeted() {
        return true;
    }

    @Override
    protected boolean useLegacyXMLIds() {
        return false;
    }
}

