/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import java.util.Properties;
import javax.transaction.TransactionManager;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;
import net.sf.hibernate.cache.TreeCache;
import net.sf.hibernate.transaction.TransactionManagerLookupFactory;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TransactionManagerLookup;

public class TreeCacheProvider
implements CacheProvider {
    private org.jboss.cache.TreeCache cache;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        return new TreeCache(this.cache, regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) throws CacheException {
        try {
            this.cache = new org.jboss.cache.TreeCache();
            PropertyConfigurator config = new PropertyConfigurator();
            config.configure((Object)this.cache, "treecache.xml");
            net.sf.hibernate.transaction.TransactionManagerLookup tml = TransactionManagerLookupFactory.getTransactionManagerLookup(properties);
            if (tml != null) {
                this.cache.setTransactionManagerLookup((TransactionManagerLookup)new TransactionManagerLookupAdaptor(tml, properties));
            }
            this.cache.start();
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void stop() {
        if (this.cache != null) {
            this.cache.stop();
            this.cache.destroy();
            this.cache = null;
        }
    }

    static final class TransactionManagerLookupAdaptor
    implements TransactionManagerLookup {
        private final net.sf.hibernate.transaction.TransactionManagerLookup tml;
        private final Properties props;

        TransactionManagerLookupAdaptor(net.sf.hibernate.transaction.TransactionManagerLookup tml, Properties props) {
            this.tml = tml;
            this.props = props;
        }

        public TransactionManager getTransactionManager() throws Exception {
            return this.tml.getTransactionManager(this.props);
        }
    }
}

