/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.plugins;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.ibator.api.GeneratedXmlFile;
import org.apache.ibatis.ibator.api.IbatorPluginAdapter;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.Document;
import org.apache.ibatis.ibator.api.dom.xml.TextElement;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.internal.util.StringUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMapConfigPlugin
extends IbatorPluginAdapter {
    private List<String> sqlMapFiles = new ArrayList<String>();

    @Override
    public boolean validate(List<String> warnings) {
        boolean valid = true;
        if (!StringUtility.stringHasValue(this.properties.getProperty("targetProject"))) {
            warnings.add(Messages.getString("ValidationError.18", "SqlMapConfigPlugin", "targetProject"));
            valid = false;
        }
        if (!StringUtility.stringHasValue(this.properties.getProperty("targetPackage"))) {
            warnings.add(Messages.getString("ValidationError.18", "SqlMapConfigPlugin", "targetPackage"));
            valid = false;
        }
        return valid;
    }

    @Override
    public List<GeneratedXmlFile> contextGenerateAdditionalXmlFiles() {
        Document document = new Document("-//ibatis.apache.org//DTD SQL Map Config 2.0//EN", "http://ibatis.apache.org/dtd/sql-map-config-2.dtd");
        XmlElement root = new XmlElement("sqlMapConfig");
        document.setRootElement(root);
        root.addElement(new TextElement("<!--"));
        root.addElement(new TextElement("  This file is generated by Apache iBATIS ibator."));
        root.addElement(new TextElement("  This file is the shell of an SqlMapConfig file - in many cases you will need to add"));
        root.addElement(new TextElement("    to this file before it is usable by iBATIS."));
        StringBuilder sb = new StringBuilder();
        sb.append("  This file was generated on ");
        sb.append(new Date());
        sb.append('.');
        root.addElement(new TextElement(sb.toString()));
        root.addElement(new TextElement("-->"));
        XmlElement settings = new XmlElement("settings");
        settings.addAttribute(new Attribute("useStatementNamespaces", "true"));
        root.addElement(settings);
        for (String sqlMapFile : this.sqlMapFiles) {
            XmlElement sqlMap = new XmlElement("sqlMap");
            sqlMap.addAttribute(new Attribute("resource", sqlMapFile));
            root.addElement(sqlMap);
        }
        GeneratedXmlFile gxf = new GeneratedXmlFile(document, this.properties.getProperty("fileName", "SqlMapConfig.xml"), this.properties.getProperty("targetPackage"), this.properties.getProperty("targetProject"), false);
        ArrayList<GeneratedXmlFile> answer = new ArrayList<GeneratedXmlFile>(1);
        answer.add(gxf);
        return answer;
    }

    @Override
    public boolean sqlMapGenerated(GeneratedXmlFile sqlMap, IntrospectedTable introspectedTable) {
        StringBuilder sb = new StringBuilder();
        sb.append(sqlMap.getTargetPackage());
        sb.append('.');
        String temp = sb.toString();
        sb.setLength(0);
        sb.append(temp.replace('.', '/'));
        sb.append(sqlMap.getFileName());
        this.sqlMapFiles.add(sb.toString());
        return true;
    }
}

