/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ibatis.ibator.internal.util.StringUtility;

public class SqlScriptRunner {
    private String driver;
    private String url;
    private String userid;
    private String password;
    private InputStream sourceFile;

    public SqlScriptRunner(InputStream sourceFile, String driver, String url, String userId, String password) throws Exception {
        if (!StringUtility.stringHasValue(driver)) {
            throw new Exception("JDBC Driver is required");
        }
        if (!StringUtility.stringHasValue(url)) {
            throw new Exception("JDBC URL is required");
        }
        this.sourceFile = sourceFile;
        this.driver = driver;
        this.url = url;
        this.userid = userId;
        this.password = password;
    }

    public void executeScript() throws Exception {
        Connection connection = null;
        try {
            String sql;
            Class.forName(this.driver);
            connection = DriverManager.getConnection(this.url, this.userid, this.password);
            Statement statement = connection.createStatement();
            BufferedReader br = new BufferedReader(new InputStreamReader(this.sourceFile));
            while ((sql = this.readStatement(br)) != null) {
                statement.execute(sql);
            }
            this.closeStatement(statement);
            connection.commit();
            br.close();
        }
        catch (Throwable throwable) {
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String readStatement(BufferedReader br) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("--") || !StringUtility.stringHasValue(line)) continue;
            if (line.endsWith(";")) {
                sb.append(line.substring(0, line.length() - 1));
                break;
            }
            sb.append(' ');
            sb.append(line);
        }
        String s = sb.toString().trim();
        return s.length() > 0 ? s : null;
    }
}

