/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis2.dao.templates;

import org.apache.ibatis.ibator.api.dom.java.Field;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.JavaVisibility;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.api.dom.java.Parameter;
import org.apache.ibatis.ibator.generator.ibatis2.dao.templates.AbstractDAOTemplate;

public class GenericCIDAOTemplate
extends AbstractDAOTemplate {
    private FullyQualifiedJavaType sqlMapClientType = new FullyQualifiedJavaType("com.ibatis.sqlmap.client.SqlMapClient");

    protected void configureCheckedExceptions() {
        this.addCheckedException(new FullyQualifiedJavaType("java.sql.SQLException"));
    }

    protected void configureConstructorTemplate() {
        Method constructor = new Method();
        constructor.setConstructor(true);
        constructor.setVisibility(JavaVisibility.PUBLIC);
        constructor.addParameter(new Parameter(this.sqlMapClientType, "sqlMapClient"));
        constructor.addBodyLine("super();");
        constructor.addBodyLine("this.sqlMapClient = sqlMapClient;");
        this.setConstructorTemplate(constructor);
    }

    protected void configureDeleteMethodTemplate() {
        this.setDeleteMethodTemplate("sqlMapClient.delete(\"{0}.{1}\", {2});");
    }

    protected void configureFields() {
        Field field = new Field();
        field.setVisibility(JavaVisibility.PRIVATE);
        field.setType(this.sqlMapClientType);
        field.setName("sqlMapClient");
        this.addField(field);
    }

    protected void configureImplementationImports() {
        this.addImplementationImport(this.sqlMapClientType);
    }

    protected void configureInsertMethodTemplate() {
        this.setInsertMethodTemplate("sqlMapClient.insert(\"{0}.{1}\", {2});");
    }

    protected void configureQueryForListMethodTemplate() {
        this.setQueryForListMethodTemplate("sqlMapClient.queryForList(\"{0}.{1}\", {2});");
    }

    protected void configureQueryForObjectMethodTemplate() {
        this.setQueryForObjectMethodTemplate("sqlMapClient.queryForObject(\"{0}.{1}\", {2});");
    }

    protected void configureUpdateMethodTemplate() {
        this.setUpdateMethodTemplate("sqlMapClient.update(\"{0}.{1}\", {2});");
    }
}

