/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis2.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ibatis.ibator.api.CommentGenerator;
import org.apache.ibatis.ibator.api.FullyQualifiedTable;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.dom.OutputUtilities;
import org.apache.ibatis.ibator.api.dom.java.CompilationUnit;
import org.apache.ibatis.ibator.api.dom.java.Field;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.InnerClass;
import org.apache.ibatis.ibator.api.dom.java.JavaVisibility;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.api.dom.java.Parameter;
import org.apache.ibatis.ibator.api.dom.java.TopLevelClass;
import org.apache.ibatis.ibator.config.IbatorContext;
import org.apache.ibatis.ibator.generator.AbstractJavaGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.Ibatis2FormattingUtilities;
import org.apache.ibatis.ibator.internal.rules.IbatorRules;
import org.apache.ibatis.ibator.internal.util.JavaBeansUtil;
import org.apache.ibatis.ibator.internal.util.StringUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExampleGenerator
extends AbstractJavaGenerator {
    private boolean generateForJava5;

    public ExampleGenerator(boolean generateForJava5) {
        this.generateForJava5 = generateForJava5;
    }

    @Override
    public List<CompilationUnit> getCompilationUnits() {
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        this.progressCallback.startTask(Messages.getString("Progress.6", table.toString()));
        CommentGenerator commentGenerator = this.ibatorContext.getCommentGenerator();
        FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.introspectedTable.getExampleType());
        TopLevelClass topLevelClass = new TopLevelClass(type);
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        commentGenerator.addJavaFileComment(topLevelClass);
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setConstructor(true);
        method.setName(type.getShortName());
        if (this.generateForJava5) {
            method.addBodyLine("oredCriteria = new ArrayList<Criteria>();");
        } else {
            method.addBodyLine("oredCriteria = new ArrayList();");
            if (this.ibatorContext.getSuppressTypeWarnings(this.introspectedTable)) {
                method.addSuppressTypeWarningsAnnotation();
            }
        }
        commentGenerator.addGeneralMethodComment(method, null);
        topLevelClass.addMethod(method);
        IbatorRules rules = this.introspectedTable.getRules();
        if (rules.generateUpdateByExampleSelective() || rules.generateUpdateByExampleWithBLOBs() || rules.generateUpdateByExampleWithoutBLOBs()) {
            method = new Method();
            method.setVisibility(JavaVisibility.PROTECTED);
            method.setConstructor(true);
            method.setName(type.getShortName());
            method.addParameter(new Parameter(type, "example"));
            method.addBodyLine("this.orderByClause = example.orderByClause;");
            method.addBodyLine("this.oredCriteria = example.oredCriteria;");
            method.addBodyLine("this.distinct = example.distinct;");
            method.addBodyLine("this.forUpdate = example.forUpdate;");
            method.addBodyLine("this.NoWait = example.NoWait;");
            commentGenerator.addGeneralMethodComment(method, null);
            topLevelClass.addMethod(method);
        }
        Field field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(FullyQualifiedJavaType.getStringInstance());
        field.setName("orderByClause");
        commentGenerator.addFieldComment(field, this.introspectedTable);
        topLevelClass.addField(field);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("setOrderByClause");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "orderByClause"));
        method.addBodyLine("this.orderByClause = orderByClause;");
        commentGenerator.addGeneralMethodComment(method, "\u8bbe\u7f6e\u6392\u5e8f");
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(FullyQualifiedJavaType.getStringInstance());
        method.setName("getOrderByClause");
        method.addBodyLine("return orderByClause;");
        commentGenerator.addGeneralMethodComment(method, "\u83b7\u53d6\u6392\u5e8f");
        topLevelClass.addMethod(method);
        field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        field.setName("distinct");
        commentGenerator.addFieldComment(field, this.introspectedTable);
        topLevelClass.addField(field);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("setDistinct");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "distinct"));
        method.addBodyLine("this.distinct = distinct;");
        commentGenerator.addGeneralMethodComment(method, "\u8bbe\u7f6e\u662f\u5426\u8fc7\u6ee4\u91cd\u590d");
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        method.setName("isDistinct");
        method.addBodyLine("return distinct;");
        commentGenerator.addGeneralMethodComment(method, "\u83b7\u53d6\u662f\u5426\u8fc7\u6ee4\u91cd\u590d");
        topLevelClass.addMethod(method);
        field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        field.setName("NoWait");
        commentGenerator.addFieldComment(field, this.introspectedTable);
        topLevelClass.addField(field);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("setNoWait");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "NoWait"));
        method.addBodyLine("this.NoWait = NoWait;");
        commentGenerator.addGeneralMethodComment(method, "\u8bbe\u7f6e\u662f\u5426\u4e0a\u9501\u662f\u5426\u4e0d\u7b49\u5f85");
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        method.setName("isNoWait");
        method.addBodyLine("return NoWait;");
        commentGenerator.addGeneralMethodComment(method, "\u8bbe\u7f6e\u662f\u5426\u4e0a\u9501\u662f\u5426\u4e0d\u7b49\u5f85");
        topLevelClass.addMethod(method);
        field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        field.setName("forUpdate");
        commentGenerator.addFieldComment(field, this.introspectedTable);
        topLevelClass.addField(field);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("setForUpdate");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "forUpdate"));
        method.addBodyLine("this.forUpdate = forUpdate;");
        commentGenerator.addGeneralMethodComment(method, "\u8bbe\u7f6e\u662f\u5426\u884c\u9501\u5b9a");
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        method.setName("isForUpdate");
        method.addBodyLine("return forUpdate;");
        commentGenerator.addGeneralMethodComment(method, "\u83b7\u53d6\u662f\u5426\u884c\u9501\u5b9a");
        topLevelClass.addMethod(method);
        field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        FullyQualifiedJavaType fqjt = this.generateForJava5 ? new FullyQualifiedJavaType("java.util.List<Criteria>") : new FullyQualifiedJavaType("java.util.List");
        field.setType(fqjt);
        if (this.ibatorContext.getSuppressTypeWarnings(this.introspectedTable)) {
            field.addSuppressTypeWarningsAnnotation();
        }
        field.setName("oredCriteria");
        commentGenerator.addFieldComment(field, this.introspectedTable);
        topLevelClass.addField(field);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(fqjt);
        if (this.ibatorContext.getSuppressTypeWarnings(this.introspectedTable)) {
            method.addSuppressTypeWarningsAnnotation();
        }
        method.setName("getOredCriteria");
        method.addBodyLine("return oredCriteria;");
        commentGenerator.addGeneralMethodComment(method, null);
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        if (this.ibatorContext.getSuppressTypeWarnings(this.introspectedTable)) {
            method.addSuppressTypeWarningsAnnotation();
        }
        method.setName("or");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getCriteriaInstance(), "criteria"));
        method.addBodyLine("oredCriteria.add(criteria);");
        commentGenerator.addGeneralMethodComment(method, null);
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        if (this.ibatorContext.getSuppressTypeWarnings(this.introspectedTable)) {
            method.addSuppressTypeWarningsAnnotation();
        }
        method.setName("or");
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        method.addBodyLine("Criteria criteria = createCriteriaInternal();");
        method.addBodyLine("oredCriteria.add(criteria);");
        method.addBodyLine("return criteria;");
        commentGenerator.addGeneralMethodComment(method, "\u6216");
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        if (this.ibatorContext.getSuppressTypeWarnings(this.introspectedTable)) {
            method.addSuppressTypeWarningsAnnotation();
        }
        method.setName("createCriteria");
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        method.addBodyLine("Criteria criteria = createCriteriaInternal();");
        method.addBodyLine("if (oredCriteria.size() == 0) {");
        method.addBodyLine("oredCriteria.add(criteria);");
        method.addBodyLine("}");
        method.addBodyLine("return criteria;");
        commentGenerator.addGeneralMethodComment(method, null);
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("createCriteriaInternal");
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        method.addBodyLine("Criteria criteria = new Criteria();");
        method.addBodyLine("return criteria;");
        commentGenerator.addGeneralMethodComment(method, null);
        topLevelClass.addMethod(method);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("clear");
        method.addBodyLine("oredCriteria.clear();");
        method.addBodyLine("orderByClause = null;");
        method.addBodyLine("distinct = false;");
        method.addBodyLine("forUpdate = false;");
        method.addBodyLine("NoWait = false;");
        commentGenerator.addGeneralMethodComment(method, "\u6e05\u9664");
        topLevelClass.addMethod(method);
        topLevelClass.addInnerClass(this.getGeneratedCriteriaInnerClass(topLevelClass));
        topLevelClass.addInnerClass(this.getCriteriaInnerClass(topLevelClass));
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        if (this.ibatorContext.getPlugins().modelExampleClassGenerated(topLevelClass, this.introspectedTable)) {
            answer.add(topLevelClass);
        }
        return answer;
    }

    private InnerClass getCriteriaInnerClass(TopLevelClass topLevelClass) {
        InnerClass answer = new InnerClass(FullyQualifiedJavaType.getCriteriaInstance());
        answer.setVisibility(JavaVisibility.PUBLIC);
        answer.setStatic(true);
        answer.setSuperClass(FullyQualifiedJavaType.getGeneratedCriteriaInstance());
        this.ibatorContext.getCommentGenerator().addClassComment(answer, this.introspectedTable);
        Method method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("Criteria");
        method.setConstructor(true);
        method.addBodyLine("super();");
        answer.addMethod(method);
        return answer;
    }

    private InnerClass getGeneratedCriteriaInnerClass(TopLevelClass topLevelClass) {
        InnerClass answer = new InnerClass(FullyQualifiedJavaType.getGeneratedCriteriaInstance());
        if (this.ibatorContext.getSuppressTypeWarnings(this.introspectedTable)) {
            answer.addSuppressTypeWarningsAnnotation();
        }
        answer.setVisibility(JavaVisibility.PROTECTED);
        answer.setStatic(true);
        answer.setAbstract(true);
        this.ibatorContext.getCommentGenerator().addClassComment(answer, this.introspectedTable);
        Method method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("GeneratedCriteria");
        method.setConstructor(true);
        method.addBodyLine("super();");
        if (this.generateForJava5) {
            method.addBodyLine("criteriaWithoutValue = new ArrayList<String>();");
            method.addBodyLine("criteriaWithSingleValue = new ArrayList<Map<String, Object>>();");
            method.addBodyLine("criteriaWithListValue = new ArrayList<Map<String, Object>>();");
            method.addBodyLine("criteriaWithBetweenValue = new ArrayList<Map<String, Object>>();");
        } else {
            method.addBodyLine("criteriaWithoutValue = new ArrayList();");
            method.addBodyLine("criteriaWithSingleValue = new ArrayList();");
            method.addBodyLine("criteriaWithListValue = new ArrayList();");
            method.addBodyLine("criteriaWithBetweenValue = new ArrayList();");
        }
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        ArrayList<String> criteriaLists = new ArrayList<String>();
        criteriaLists.add("criteriaWithoutValue");
        criteriaLists.add("criteriaWithSingleValue");
        criteriaLists.add("criteriaWithListValue");
        criteriaLists.add("criteriaWithBetweenValue");
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getNonBLOBColumns()) {
            if (!StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) continue;
            criteriaLists.addAll(this.addtypeHandledObjectsAndMethods(introspectedColumn, method, answer));
        }
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("isValid");
        method.setReturnType(FullyQualifiedJavaType.getBooleanPrimitiveInstance());
        StringBuilder sb = new StringBuilder();
        Iterator strIter = criteriaLists.iterator();
        sb.append("return ");
        sb.append((String)strIter.next());
        sb.append(".size() > 0");
        method.addBodyLine(sb.toString());
        while (strIter.hasNext()) {
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append("|| ");
            sb.append((String)strIter.next());
            sb.append(".size() > 0");
            if (!strIter.hasNext()) {
                sb.append(';');
            }
            method.addBodyLine(sb.toString());
        }
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u9a8c\u8bc1");
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewMapInstance());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewListInstance());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewHashMapInstance());
        topLevelClass.addImportedType(FullyQualifiedJavaType.getNewArrayListInstance());
        Field field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        FullyQualifiedJavaType listOfStrings = this.generateForJava5 ? new FullyQualifiedJavaType("java.util.List<java.lang.String>") : new FullyQualifiedJavaType("java.util.List");
        field.setType(listOfStrings);
        field.setName("criteriaWithoutValue");
        answer.addField(field);
        this.ibatorContext.getCommentGenerator().addFieldComment(field, this.introspectedTable);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(field.getType());
        method.setName(JavaBeansUtil.getGetterMethodName(field.getName(), field.getType()));
        method.addBodyLine("return criteriaWithoutValue;");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName(JavaBeansUtil.getSetterMethodName(field.getName()));
        method.addParameter(new Parameter(field.getType(), "criteriaWithoutValue"));
        method.addBodyLine("this.criteriaWithoutValue = criteriaWithoutValue;");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        FullyQualifiedJavaType listOfMaps = this.generateForJava5 ? new FullyQualifiedJavaType("java.util.List<java.util.Map<java.lang.String, java.lang.Object>>") : new FullyQualifiedJavaType("java.util.List");
        field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(listOfMaps);
        field.setName("criteriaWithSingleValue");
        answer.addField(field);
        this.ibatorContext.getCommentGenerator().addFieldComment(field, this.introspectedTable);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(field.getType());
        method.setName(JavaBeansUtil.getGetterMethodName(field.getName(), field.getType()));
        method.addBodyLine("return criteriaWithSingleValue;");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName(JavaBeansUtil.getSetterMethodName(field.getName()));
        method.addParameter(new Parameter(field.getType(), "criteriaWithSingleValue"));
        method.addBodyLine("this.criteriaWithSingleValue = criteriaWithSingleValue;");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(listOfMaps);
        field.setName("criteriaWithListValue");
        answer.addField(field);
        this.ibatorContext.getCommentGenerator().addFieldComment(field, this.introspectedTable);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(field.getType());
        method.setName(JavaBeansUtil.getGetterMethodName(field.getName(), field.getType()));
        method.addBodyLine("return criteriaWithListValue;");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName(JavaBeansUtil.getSetterMethodName(field.getName()));
        method.addParameter(new Parameter(field.getType(), "criteriaWithListValue"));
        method.addBodyLine("this.criteriaWithListValue = criteriaWithListValue;");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(listOfMaps);
        field.setName("criteriaWithBetweenValue");
        answer.addField(field);
        this.ibatorContext.getCommentGenerator().addFieldComment(field, this.introspectedTable);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(field.getType());
        method.setName(JavaBeansUtil.getGetterMethodName(field.getName(), field.getType()));
        method.addBodyLine("return criteriaWithBetweenValue;");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName(JavaBeansUtil.getSetterMethodName(field.getName()));
        method.addParameter(new Parameter(field.getType(), "criteriaWithBetweenValue"));
        method.addBodyLine("this.criteriaWithBetweenValue = criteriaWithBetweenValue;");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("whereSQL");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addBodyLine("if (condition == null) {");
        method.addBodyLine("throw new RuntimeException(\"Value for condition cannot be null\");");
        method.addBodyLine("}");
        method.addBodyLine("criteriaWithoutValue.add(condition);");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("addCriterion");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addBodyLine("if (condition == null) {");
        method.addBodyLine("throw new RuntimeException(\"Value for condition cannot be null\");");
        method.addBodyLine("}");
        method.addBodyLine("criteriaWithoutValue.add(condition);");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("addCriterion");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (value == null) {");
        method.addBodyLine("throw new RuntimeException(\"Value for \" + property + \" cannot be null\");");
        method.addBodyLine("}");
        if (this.generateForJava5) {
            method.addBodyLine("Map<String, Object> map = new HashMap<String, Object>();");
        } else {
            method.addBodyLine("Map map = new HashMap();");
        }
        method.addBodyLine("map.put(\"condition\", condition);");
        method.addBodyLine("map.put(\"value\", value);");
        method.addBodyLine("criteriaWithSingleValue.add(map);");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        FullyQualifiedJavaType listOfObjects = this.generateForJava5 ? new FullyQualifiedJavaType("java.util.List<? extends java.lang.Object>") : new FullyQualifiedJavaType("java.util.List");
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("addCriterion");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(listOfObjects, "values"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (values == null || values.size() == 0) {");
        method.addBodyLine("throw new RuntimeException(\"Value list for \" + property + \" cannot be null or empty\");");
        method.addBodyLine("}");
        if (this.generateForJava5) {
            method.addBodyLine("Map<String, Object> map = new HashMap<String, Object>();");
        } else {
            method.addBodyLine("Map map = new HashMap();");
        }
        method.addBodyLine("map.put(\"condition\", condition);");
        method.addBodyLine("map.put(\"values\", values);");
        method.addBodyLine("criteriaWithListValue.add(map);");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName("addCriterion");
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value1"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getObjectInstance(), "value2"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (value1 == null || value2 == null) {");
        method.addBodyLine("throw new RuntimeException(\"Between values for \" + property + \" cannot be null\");");
        method.addBodyLine("}");
        if (this.generateForJava5) {
            method.addBodyLine("List<Object> list = new ArrayList<Object>();");
        } else {
            method.addBodyLine("List list = new ArrayList();");
        }
        method.addBodyLine("list.add(value1);");
        method.addBodyLine("list.add(value2);");
        if (this.generateForJava5) {
            method.addBodyLine("Map<String, Object> map = new HashMap<String, Object>();");
        } else {
            method.addBodyLine("Map map = new HashMap();");
        }
        method.addBodyLine("map.put(\"condition\", condition);");
        method.addBodyLine("map.put(\"values\", list);");
        method.addBodyLine("criteriaWithBetweenValue.add(map);");
        answer.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getNonBLOBColumns()) {
            topLevelClass.addImportedType(introspectedColumn.getFullyQualifiedJavaType());
            Method methodTmp = this.getSetNullMethod(introspectedColumn);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            methodTmp = this.getSetNotNullMethod(introspectedColumn);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            methodTmp = this.getSetEqualMethod(introspectedColumn);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            methodTmp = this.getSetNotEqualMethod(introspectedColumn);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            methodTmp = this.getSetGreaterThanMethod(introspectedColumn);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            methodTmp = this.getSetGreaterThenOrEqualMethod(introspectedColumn);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            methodTmp = this.getSetLessThanMethod(introspectedColumn);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            methodTmp = this.getSetLessThanOrEqualMethod(introspectedColumn);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            if (introspectedColumn.isJdbcCharacterColumn()) {
                methodTmp = this.getSetLikeMethod(introspectedColumn);
                answer.addMethod(methodTmp);
                this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
                methodTmp = this.getSetNotLikeMethod(introspectedColumn);
                answer.addMethod(methodTmp);
                this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            }
            methodTmp = this.getSetInOrNotInMethod(introspectedColumn, true);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            methodTmp = this.getSetInOrNotInMethod(introspectedColumn, false);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            methodTmp = this.getSetBetweenOrNotBetweenMethod(introspectedColumn, true);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
            methodTmp = this.getSetBetweenOrNotBetweenMethod(introspectedColumn, false);
            answer.addMethod(methodTmp);
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(methodTmp, null);
        }
        return answer;
    }

    private List<String> addtypeHandledObjectsAndMethods(IntrospectedColumn introspectedColumn, Method constructor, InnerClass innerClass) {
        ArrayList<String> answer = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        FullyQualifiedJavaType listOfMaps = this.generateForJava5 ? new FullyQualifiedJavaType("java.util.List<java.util.Map<java.lang.String, java.lang.Object>>") : new FullyQualifiedJavaType("java.util.List");
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("CriteriaWithSingleValue");
        answer.add(sb.toString());
        Field field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(listOfMaps);
        field.setName(sb.toString());
        innerClass.addField(field);
        this.ibatorContext.getCommentGenerator().addFieldComment(field, this.introspectedTable, introspectedColumn);
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(field.getType());
        method.setName(JavaBeansUtil.getGetterMethodName(field.getName(), field.getType()));
        sb.insert(0, "return ");
        sb.append(';');
        method.addBodyLine(sb.toString());
        innerClass.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("CriteriaWithListValue");
        answer.add(sb.toString());
        field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(listOfMaps);
        field.setName(sb.toString());
        innerClass.addField(field);
        this.ibatorContext.getCommentGenerator().addFieldComment(field, this.introspectedTable, introspectedColumn);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(field.getType());
        method.setName(JavaBeansUtil.getGetterMethodName(field.getName(), field.getType()));
        sb.insert(0, "return ");
        sb.append(';');
        method.addBodyLine(sb.toString());
        innerClass.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("CriteriaWithBetweenValue");
        answer.add(sb.toString());
        field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(listOfMaps);
        field.setName(sb.toString());
        innerClass.addField(field);
        this.ibatorContext.getCommentGenerator().addFieldComment(field, this.introspectedTable, introspectedColumn);
        method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setReturnType(field.getType());
        method.setName(JavaBeansUtil.getGetterMethodName(field.getName(), field.getType()));
        sb.insert(0, "return ");
        sb.append(';');
        method.addBodyLine(sb.toString());
        innerClass.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        if (this.generateForJava5) {
            sb.append("CriteriaWithSingleValue = new ArrayList<Map<String, Object>>();");
        } else {
            sb.append("CriteriaWithSingleValue = new ArrayList();");
        }
        constructor.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        if (this.generateForJava5) {
            sb.append("CriteriaWithListValue = new ArrayList<Map<String, Object>>();");
        } else {
            sb.append("CriteriaWithListValue = new ArrayList();");
        }
        constructor.addBodyLine(sb.toString());
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        if (this.generateForJava5) {
            sb.append("CriteriaWithBetweenValue = new ArrayList<Map<String, Object>>();");
        } else {
            sb.append("CriteriaWithBetweenValue = new ArrayList();");
        }
        constructor.addBodyLine(sb.toString());
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        sb.setLength(0);
        sb.append("add");
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        sb.append("Criterion");
        method.setName(sb.toString());
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (value == null) {");
        method.addBodyLine("throw new RuntimeException(\"Value for \" + property + \" cannot be null\");");
        method.addBodyLine("}");
        if (this.generateForJava5) {
            method.addBodyLine("Map<String, Object> map = new HashMap<String, Object>();");
        } else {
            method.addBodyLine("Map map = new HashMap();");
        }
        method.addBodyLine("map.put(\"condition\", condition);");
        method.addBodyLine("map.put(\"value\", value);");
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("CriteriaWithSingleValue.add(map);");
        method.addBodyLine(sb.toString());
        innerClass.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        FullyQualifiedJavaType listOfObjects = FullyQualifiedJavaType.getNewListInstance();
        if (this.generateForJava5) {
            listOfObjects.addTypeArgument(introspectedColumn.getFullyQualifiedJavaType());
        }
        sb.setLength(0);
        sb.append("add");
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        sb.append("Criterion");
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName(sb.toString());
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(listOfObjects, "values"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (values == null || values.size() == 0) {");
        method.addBodyLine("throw new RuntimeException(\"Value list for \" + property + \" cannot be null or empty\");");
        method.addBodyLine("}");
        if (this.generateForJava5) {
            method.addBodyLine("Map<String, Object> map = new HashMap<String, Object>();");
        } else {
            method.addBodyLine("Map map = new HashMap();");
        }
        method.addBodyLine("map.put(\"condition\", condition);");
        method.addBodyLine("map.put(\"values\", values);");
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("CriteriaWithListValue.add(map);");
        method.addBodyLine(sb.toString());
        innerClass.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        sb.setLength(0);
        sb.append("add");
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
        sb.append("Criterion");
        method = new Method();
        method.setVisibility(JavaVisibility.PROTECTED);
        method.setName(sb.toString());
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "condition"));
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value1"));
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value2"));
        method.addParameter(new Parameter(FullyQualifiedJavaType.getStringInstance(), "property"));
        method.addBodyLine("if (value1 == null || value2 == null) {");
        method.addBodyLine("throw new RuntimeException(\"Between values for \" + property + \" cannot be null\");");
        method.addBodyLine("}");
        if (this.generateForJava5) {
            sb.setLength(0);
            sb.append("List<");
            sb.append(introspectedColumn.getFullyQualifiedJavaType().getShortName());
            sb.append("> list = new ArrayList<");
            sb.append(introspectedColumn.getFullyQualifiedJavaType().getShortName());
            sb.append(">();");
            method.addBodyLine(sb.toString());
        } else {
            method.addBodyLine("List list = new ArrayList();");
        }
        method.addBodyLine("list.add(value1);");
        method.addBodyLine("list.add(value2);");
        if (this.generateForJava5) {
            method.addBodyLine("Map<String, Object> map = new HashMap<String, Object>();");
        } else {
            method.addBodyLine("Map map = new HashMap();");
        }
        method.addBodyLine("map.put(\"condition\", condition);");
        method.addBodyLine("map.put(\"values\", list);");
        sb.setLength(0);
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("CriteriaWithBetweenValue.add(map);");
        method.addBodyLine(sb.toString());
        innerClass.addMethod(method);
        this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, null);
        return answer;
    }

    private boolean isOracle() {
        return IbatorContext.jdbcConnectionConfiguration.getDriverClass().toLowerCase().indexOf("oracle.") >= 0;
    }

    private Method getSetNullMethod(IntrospectedColumn introspectedColumn) {
        return this.getNoValueMethod(introspectedColumn, "IsNull", "is null");
    }

    private Method getSetNotNullMethod(IntrospectedColumn introspectedColumn) {
        if (this.isOracle()) {
            return this.getNoValueMethod(introspectedColumn, "IsNotNull", "is not null");
        }
        return this.getNoValueMethod(introspectedColumn, "IsNotNull", "<> ''");
    }

    private Method getSetEqualMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "EqualTo", "=");
    }

    private Method getSetNotEqualMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "NotEqualTo", "<>");
    }

    private Method getSetGreaterThanMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "GreaterThan", ">");
    }

    private Method getSetGreaterThenOrEqualMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "GreaterThanOrEqualTo", ">=");
    }

    private Method getSetLessThanMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "LessThan", "<");
    }

    private Method getSetLessThanOrEqualMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "LessThanOrEqualTo", "<=");
    }

    private Method getSetLikeMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "Like", "like");
    }

    private Method getSetNotLikeMethod(IntrospectedColumn introspectedColumn) {
        return this.getSingleValueMethod(introspectedColumn, "NotLike", "not like");
    }

    private Method getSingleValueMethod(IntrospectedColumn introspectedColumn, String nameFragment, String operator) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), "value"));
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        sb.append(nameFragment);
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);
        if (introspectedColumn.isJDBCDateColumn()) {
            sb.append("addCriterion(\"");
        } else if (introspectedColumn.isJDBCTimeColumn()) {
            sb.append("addCriterion(\"");
        } else if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append("add");
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
            sb.append("Criterion(\"");
        } else {
            sb.append("addCriterion(\"");
        }
        sb.append(Ibatis2FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        sb.append(' ');
        sb.append(operator);
        sb.append("\", ");
        if (introspectedColumn.getFullyQualifiedJavaType().isPrimitive()) {
            sb.append("new ");
            sb.append(introspectedColumn.getFullyQualifiedJavaType().getPrimitiveTypeWrapper().getShortName());
            sb.append("(value)");
        } else {
            sb.append("value");
        }
        sb.append(", \"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");
        return method;
    }

    private Method getSetBetweenOrNotBetweenMethod(IntrospectedColumn introspectedColumn, boolean betweenMethod) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType type = introspectedColumn.getFullyQualifiedJavaType();
        method.addParameter(new Parameter(type, "value1"));
        method.addParameter(new Parameter(type, "value2"));
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        if (betweenMethod) {
            sb.append("Between");
        } else {
            sb.append("NotBetween");
        }
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);
        if (introspectedColumn.isJDBCDateColumn()) {
            sb.append("addCriterion(\"");
        } else if (introspectedColumn.isJDBCTimeColumn()) {
            sb.append("addCriterion(\"");
        } else if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append("add");
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
            sb.append("Criterion(\"");
        } else {
            sb.append("addCriterion(\"");
        }
        sb.append(Ibatis2FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        if (betweenMethod) {
            sb.append(" between");
        } else {
            sb.append(" not between");
        }
        sb.append("\", ");
        if (introspectedColumn.getFullyQualifiedJavaType().isPrimitive()) {
            sb.append("new ");
            sb.append(introspectedColumn.getFullyQualifiedJavaType().getPrimitiveTypeWrapper().getShortName());
            sb.append("(value1), ");
            sb.append("new ");
            sb.append(introspectedColumn.getFullyQualifiedJavaType().getPrimitiveTypeWrapper().getShortName());
            sb.append("(value2)");
        } else {
            sb.append("value1, value2");
        }
        sb.append(", \"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");
        return method;
    }

    private Method getSetInOrNotInMethod(IntrospectedColumn introspectedColumn, boolean inMethod) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        FullyQualifiedJavaType type = FullyQualifiedJavaType.getNewListInstance();
        if (this.generateForJava5) {
            if (introspectedColumn.getFullyQualifiedJavaType().isPrimitive()) {
                type.addTypeArgument(introspectedColumn.getFullyQualifiedJavaType().getPrimitiveTypeWrapper());
            } else {
                type.addTypeArgument(introspectedColumn.getFullyQualifiedJavaType());
            }
        }
        method.addParameter(new Parameter(type, "values"));
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        if (inMethod) {
            sb.append("In");
        } else {
            sb.append("NotIn");
        }
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);
        if (introspectedColumn.isJDBCDateColumn()) {
            sb.append("addCriterion(\"");
        } else if (introspectedColumn.isJDBCTimeColumn()) {
            sb.append("addCriterion(\"");
        } else if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            sb.append("add");
            sb.append(introspectedColumn.getJavaProperty());
            sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
            sb.append("Criterion(\"");
        } else {
            sb.append("addCriterion(\"");
        }
        sb.append(Ibatis2FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        if (inMethod) {
            sb.append(" in");
        } else {
            sb.append(" not in");
        }
        sb.append("\", values, \"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");
        return method;
    }

    private Method getNoValueMethod(IntrospectedColumn introspectedColumn, String nameFragment, String operator) {
        Method method = new Method();
        method.setVisibility(JavaVisibility.PUBLIC);
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        sb.append(nameFragment);
        method.setName(sb.toString());
        method.setReturnType(FullyQualifiedJavaType.getCriteriaInstance());
        sb.setLength(0);
        sb.append("addCriterion(\"");
        sb.append(Ibatis2FormattingUtilities.getAliasedActualColumnName(introspectedColumn));
        sb.append(' ');
        sb.append(operator);
        sb.append("\");");
        method.addBodyLine(sb.toString());
        method.addBodyLine("return (Criteria) this;");
        return method;
    }
}

