/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis2.sqlmap.elements;

import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.generator.ibatis2.Ibatis2FormattingUtilities;
import org.apache.ibatis.ibator.generator.ibatis2.sqlmap.elements.AbstractXmlElementGenerator;
import org.apache.ibatis.ibator.internal.util.StringUtility;

public class ResultMapWithoutBLOBsElementGenerator
extends AbstractXmlElementGenerator {
    public void addElements(XmlElement parentElement) {
        boolean useColumnIndex = StringUtility.isTrue(this.introspectedTable.getTableConfigurationProperty("useColumnIndexes"));
        XmlElement answer = new XmlElement("resultMap");
        answer.addAttribute(new Attribute("id", this.introspectedTable.getBaseResultMapId()));
        String returnType = this.introspectedTable.getRules().generateBaseRecordClass() ? this.introspectedTable.getBaseRecordType() : this.introspectedTable.getPrimaryKeyType();
        answer.addAttribute(new Attribute("class", returnType));
        this.ibatorContext.getCommentGenerator().addComment(answer);
        int i = 1;
        if (StringUtility.stringHasValue(this.introspectedTable.getSelectByPrimaryKeyQueryId()) || StringUtility.stringHasValue(this.introspectedTable.getSelectByExampleQueryId())) {
            ++i;
        }
        for (IntrospectedColumn introspectedColumn : this.introspectedTable.getNonBLOBColumns()) {
            XmlElement resultElement = new XmlElement("result");
            if (useColumnIndex) {
                resultElement.addAttribute(new Attribute("columnIndex", Integer.toString(i++)));
            } else {
                resultElement.addAttribute(new Attribute("column", Ibatis2FormattingUtilities.getRenamedColumnNameForResultMap(introspectedColumn)));
            }
            resultElement.addAttribute(new Attribute("property", introspectedColumn.getJavaProperty()));
            resultElement.addAttribute(new Attribute("jdbcType", introspectedColumn.getJdbcTypeName()));
            if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
                resultElement.addAttribute(new Attribute("typeHandler", introspectedColumn.getTypeHandler()));
            }
            answer.addElement(resultElement);
        }
        if (this.ibatorContext.getPlugins().sqlMapResultMapWithoutBLOBsElementGenerated(answer, this.introspectedTable)) {
            parentElement.addElement(answer);
        }
    }
}

