/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.model;

import com.miniframe.designer.csv.CsvReader;
import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.util.DesignerTools;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class XmlConfMap
extends LinkedHashMap {
    private static final long serialVersionUID = -9157638697378959489L;
    private static final Logger logger = Logger.getLogger(XmlConfMap.class);

    private void getCodeName(String fileName) {
        System.out.println(fileName);
        File file = new File(fileName);
        String tmp1 = file.getParent();
        int i = tmp1.indexOf("\u901a\u8baf\u62a5\u6587");
        tmp1 = tmp1.substring(i + 5);
        i = tmp1.indexOf("(");
        int j = tmp1.indexOf(")");
        String sortCode = DesignerTools.camelName(tmp1.substring(0, i)).toLowerCase();
        String sortName = tmp1.substring(i + 1, j);
        String tmp2 = file.getName();
        i = tmp2.indexOf("(");
        j = tmp2.indexOf(")");
        String code = tmp2.substring(0, i);
        int k = code.indexOf("_");
        if (k > 0) {
            code = code.substring(k + 1) + "_" + code.substring(0, k);
        }
        String name = tmp2.substring(i + 1, j);
        this.setCode(code);
        this.setName(name);
        this.setSortCode(sortCode);
        this.setSortName(sortName);
    }

    public XmlConfMap(String fileName, String ruleDir, String appcodeDir) throws Exception {
        Map appcodeMap;
        int i;
        LinkedHashMap<String, String> itemMap;
        this.getCodeName(fileName);
        CsvReader r = new CsvReader(fileName, ',', Charset.forName("UTF-8"));
        ArrayList<String> headerList = new ArrayList<String>();
        if (r.readRecord()) {
            for (int i2 = 0; i2 < r.getColumnCount(); ++i2) {
                headerList.add(r.get(i2));
            }
        }
        ArrayList allRecode = new ArrayList();
        while (r.readRecord()) {
            itemMap = new LinkedHashMap<String, String>();
            for (i = 0; i < headerList.size(); ++i) {
                String head = (String)headerList.get(i);
                if (head.startsWith("\"")) {
                    head = head.substring(1);
                }
                if (head.endsWith("\"")) {
                    head = head.substring(0, head.length() - 1);
                }
                head = head.trim();
                itemMap.put(head, r.get(i).trim());
            }
            allRecode.add(itemMap);
        }
        itemMap = new LinkedHashMap();
        for (i = 0; i < allRecode.size(); ++i) {
            String countName;
            appcodeMap = (Map)allRecode.get(i);
            String itemsort = (String)appcodeMap.get("\u6570\u636e\u7c7b\u578b");
            if (itemsort == null || !"list".equals(itemsort.trim().toLowerCase()) || !DesignerTools.isNotNullAndBlank(countName = (String)appcodeMap.get("\u975e\u7a7a/\u5f15\u7528")) || !countName.trim().startsWith("#")) continue;
            countName = countName.substring(1);
            itemMap.put(countName.toLowerCase().trim(), "");
        }
        logger.error(itemMap);
        Map globalRulMap = MiniVelocityEngine.getRuleMap(ruleDir);
        appcodeMap = MiniVelocityEngine.getAppCodeMap(appcodeDir);
        for (i = 0; i < allRecode.size(); ++i) {
            String name;
            String appcode;
            Map csvmap = (Map)allRecode.get(i);
            String itemCode = (String)csvmap.get("\u82f1\u6587\u540d\u79f0");
            if (itemMap.get(itemCode.toLowerCase().trim()) != null) {
                csvmap.put("REFERRED", "true");
            } else {
                csvmap.put("REFERRED", "false");
            }
            String rule = (String)csvmap.get("\u9a8c\u8bc1\u89c4\u5219");
            if (DesignerTools.isNotNullAndBlank(rule)) {
                Map ruleMap = (Map)globalRulMap.get(rule.trim());
                if (ruleMap != null) {
                    csvmap.put("\u6b63\u5219\u8868\u8fbe\u5f0f", ruleMap.get("\u6b63\u5219\u8868\u8fbe\u5f0f"));
                    csvmap.put("\u63d0\u793a\u4fe1\u606f", ruleMap.get("\u63d0\u793a\u4fe1\u606f"));
                } else {
                    logger.error((Object)("[ " + fileName + " ]\u7684\u9a8c\u8bc1\u89c4\u5219:[ " + rule + " ]\u4e0d\u5b58\u5728,\u9a8c\u8bc1\u89c4\u5219\u5f55\u5165\u9519\u8bef,\u88ab\u751f\u6210\u5ffd\u7565!"));
                    csvmap.put("\u9a8c\u8bc1\u89c4\u5219", null);
                }
            }
            if (DesignerTools.isNotNullAndBlank(appcode = (String)csvmap.get("\u6807\u51c6\u6570\u636eID"))) {
                name = (String)appcodeMap.get(appcode.trim());
                if (DesignerTools.isNotNullAndBlank(name)) {
                    csvmap.put("\u6807\u51c6\u6570\u636e\u540d\u79f0", name);
                } else {
                    logger.error((Object)("[ " + fileName + " ]\u7684\u6807\u51c6\u6570\u636eID:[ " + appcode + " ]\u4e0d\u5b58\u5728,\u6807\u51c6\u6570\u636eID\u5f55\u5165\u9519\u8bef,\u88ab\u751f\u6210\u5ffd\u7565!"));
                    csvmap.put("\u6807\u51c6\u6570\u636eID", null);
                }
            }
            name = (String)csvmap.get("\u5e8f\u53f7");
            XmlConfMap.putMap(this, name, csvmap);
        }
        this.setCodeName(this, this.getCode(), this.getName());
        this.checkData(this);
    }

    private void checkData(Map map) {
        Iterator it = map.entrySet().iterator();
        String parent = (String)map.get("\u5e8f\u53f7");
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!(entry.getValue() instanceof Map)) continue;
            Map tmp = (Map)entry.getValue();
            Object obj = tmp.get("\u5e8f\u53f7");
            if (obj == null) {
                if (parent == null) {
                    logger.error((Object)("\u5e8f\u53f7\u4e3a[ " + entry.getKey() + " ]\u4e0d\u5b58\u5728,\u4f46\u662f\u5b58\u5728\u5176\u5b50\u8282\u70b9,\u6570\u636e\u7f16\u8f91\u9519\u8bef!"));
                    continue;
                }
                logger.error((Object)("\u5e8f\u53f7\u4e3a[ " + parent + " ]\u5185\u7684\u5b50\u8282\u70b9[ " + entry.getKey() + " ]\u4e0d\u5b58\u5728,\u4f46\u662f\u5b58\u5728\u5176\u5b50\u8282\u70b9,\u6570\u636e\u7f16\u8f91\u9519\u8bef!"));
                continue;
            }
            this.checkData(tmp);
        }
    }

    private void setCodeName(Map map, String preKey, String preName) {
        String sortCode = (String)map.get("sortCode");
        String sortName = (String)map.get("sortName");
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map tmp;
            Object obj;
            Map.Entry entry = it.next();
            if (!(entry.getValue() instanceof Map) || (obj = (tmp = (Map)entry.getValue()).get("\u5e8f\u53f7")) == null) continue;
            String childType = (String)tmp.get("\u6570\u636e\u7c7b\u578b");
            if (!(childType = childType.trim().toLowerCase()).equals("list") && !childType.equals("map")) continue;
            String formCode = preKey + "_" + tmp.get("\u82f1\u6587\u540d\u79f0");
            String formName = preName + "->" + (String)tmp.get("\u4e2d\u6587\u540d\u79f0");
            tmp.put("code", formCode + "_Recode");
            tmp.put("name", formName);
            tmp.put("sortCode", sortCode);
            tmp.put("sortName", sortName);
            this.setCodeName(tmp, formCode, formName);
        }
        return;
    }

    public static Map getMap(Map map, String key) {
        Map ret = null;
        int i = key.indexOf(".");
        if (key.indexOf(".") > 0) {
            String pKey = key.substring(0, i);
            String nKey = key.substring(i + 1);
            if (map.get(pKey) == null) {
                return ret;
            }
            XmlConfMap.getMap((Map)map.get(pKey), nKey);
            return ret;
        }
        return (Map)map.get(key);
    }

    public static void putMap(Map map, String key, Map child) {
        int i = key.indexOf(".");
        if (key.indexOf(".") > 0) {
            String pKey = key.substring(0, i);
            String nKey = key.substring(i + 1);
            Map mychild = (Map)map.get(pKey);
            if (mychild == null) {
                LinkedHashMap tmp = new LinkedHashMap();
                XmlConfMap.putMap(tmp, nKey, child);
                map.put(pKey, tmp);
            } else if (nKey.indexOf(".") > 0) {
                XmlConfMap.putMap(mychild, nKey, child);
            } else {
                mychild.put(nKey, child);
            }
        } else {
            map.put(key, child);
        }
    }

    public String getSortCode() {
        return (String)this.get("sortCode");
    }

    public void setSortCode(String sortCode) {
        this.put("sortCode", sortCode);
    }

    public String getSortName() {
        return (String)this.get("sortName");
    }

    public void setSortName(String sortName) {
        this.put("sortName", sortName);
    }

    public String getCode() {
        return (String)this.get("code");
    }

    public void setCode(String code) {
        this.put("code", code);
    }

    public String getName() {
        return (String)this.get("name");
    }

    public void setName(String name) {
        this.put("name", name);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

