/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.dialect.Dialect;

public class ForUpdateFragment {
    private StringBuffer aliases = new StringBuffer();
    private boolean isNowaitEnabled;

    public ForUpdateFragment addTableAlias(String alias) {
        if (this.aliases.length() > 0) {
            this.aliases.append(", ");
        }
        this.aliases.append(alias);
        return this;
    }

    public String toFragmentString(Dialect dialect) {
        boolean nowait;
        if (this.aliases.length() == 0) {
            return "";
        }
        boolean bl = nowait = this.isNowaitEnabled && dialect.supportsForUpdateNowait();
        if (dialect.supportsForUpdateOf()) {
            return " for update of " + this.aliases + (nowait ? " nowait" : "");
        }
        if (dialect.supportsForUpdate()) {
            return " for update" + (nowait ? " nowait" : "");
        }
        return "";
    }

    public ForUpdateFragment setNowaitEnabled(boolean nowait) {
        this.isNowaitEnabled = nowait;
        return this;
    }

    public ForUpdateFragment() {
    }

    public ForUpdateFragment(Map lockModes) throws QueryException {
        LockMode upgradeType = null;
        Iterator iter = lockModes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            LockMode lockMode = (LockMode)me.getValue();
            if (!LockMode.READ.lessThan(lockMode)) continue;
            this.addTableAlias((String)me.getKey());
            if (upgradeType != null && lockMode != upgradeType) {
                throw new QueryException("mixed LockModes");
            }
            upgradeType = lockMode;
        }
        if (upgradeType == LockMode.UPGRADE_NOWAIT) {
            this.setNowaitEnabled(true);
        }
    }
}

