/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.model.CodeInfo;
import com.miniframe.designer.util.DesignerTools;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class ValidateFormEngine
extends MiniVelocityEngine {
    private static final Logger logger = Logger.getLogger(ValidateFormEngine.class);
    private static final String DATADIR = "dataDir";
    private static final String RULEDIR = "ruleDir";
    private static final String APPCODEDIR = "appcodeDir";
    private static final String FORMDIR = "formDir";
    private static final String FORMTEMPLATE = "formTemplate";
    private static final String FORMMSGDIR = "formMsgDir";
    private static final String FORMMSGTEMPLATE = "formMsgTemplate";

    public static void main(String[] args) throws Exception {
        Map globalRulMap = MiniVelocityEngine.getRuleMap(ValidateFormEngine.getDir(RULEDIR));
        Map appcodeMap = MiniVelocityEngine.getAppCodeMap(ValidateFormEngine.getDir(APPCODEDIR));
        List<CodeInfo> list = ValidateFormEngine.findDesigner(ValidateFormEngine.getDir(DATADIR));
        for (int i = 0; i < list.size(); ++i) {
            CodeInfo info = list.get(i);
            List<Map<String, String>> cList = info.getList();
            for (int j = 0; j < cList.size(); ++j) {
                String appcode;
                Map<String, String> newMap = cList.get(j);
                String rule = newMap.get("\u9a8c\u8bc1\u89c4\u5219");
                if (DesignerTools.isNotNullAndBlank(rule)) {
                    Map ruleMap = (Map)globalRulMap.get(rule.trim());
                    if (ruleMap != null) {
                        newMap.put("\u6b63\u5219\u8868\u8fbe\u5f0f", (String)ruleMap.get("\u6b63\u5219\u8868\u8fbe\u5f0f"));
                        newMap.put("\u63d0\u793a\u4fe1\u606f", (String)ruleMap.get("\u63d0\u793a\u4fe1\u606f"));
                        logger.error(newMap);
                    } else {
                        logger.error((Object)("[ " + info.getCode() + " ]\u7684\u9a8c\u8bc1\u89c4\u5219:[ " + rule + " ]\u4e0d\u5b58\u5728,\u9a8c\u8bc1\u89c4\u5219\u5f55\u5165\u9519\u8bef,\u88ab\u751f\u6210\u5ffd\u7565!"));
                        newMap.put("\u9a8c\u8bc1\u89c4\u5219", null);
                    }
                }
                if (!DesignerTools.isNotNullAndBlank(appcode = newMap.get("\u6807\u51c6\u6570\u636eID"))) continue;
                String name = (String)appcodeMap.get(appcode.trim());
                if (DesignerTools.isNotNullAndBlank(name)) {
                    newMap.put("\u6807\u51c6\u6570\u636e\u540d\u79f0", name);
                    continue;
                }
                logger.error((Object)("\u6807\u51c6\u6570\u636eID:[ " + appcode + " ]\u4e0d\u5b58\u5728,\u6807\u51c6\u6570\u636eID\u5f55\u5165\u9519\u8bef,\u88ab\u751f\u6210\u5ffd\u7565!"));
                newMap.put("\u6807\u51c6\u6570\u636eID", null);
            }
            ValidateFormEngine.formGenerator(info);
            String fileName1 = ValidateFormEngine.getDir(FORMMSGDIR) + "resources_" + info.getCode() + "_validator.properties";
            String fileName2 = ValidateFormEngine.getDir(FORMMSGDIR) + "resources_" + info.getCode() + "_validator_zh_CN.properties";
            ValidateFormEngine.formMsgGenerator(info, fileName1);
            ValidateFormEngine.formMsgGenerator(info, fileName2);
        }
    }

    public static void formGenerator(CodeInfo codeinfo) {
        String formTemplate = ValidateFormEngine.getSysProperty(FORMTEMPLATE);
        File file = new File(formTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + formTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            Map<?, ?> map = ValidateFormEngine.obj2Map(codeinfo);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("VelocityContext - " + map.toString()));
            }
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String value = MiniVelocityEngine.encode(ctx, formTemplate);
                if (value.indexOf("<field") > 0) {
                    MiniVelocityEngine.writefile(value, ValidateFormEngine.getDir(FORMDIR) + codeinfo.getCode() + ".xml");
                }
            }
            catch (Exception var6) {
                logger.error((Object)"\u751f\u6210\u6587\u4ef6\u9519\u8bef:", (Throwable)var6);
            }
        }
    }

    public static void formMsgGenerator(CodeInfo codeinfo, String createFileName) {
        String formMsgTemplate = ValidateFormEngine.getSysProperty(FORMMSGTEMPLATE);
        File file = new File(formMsgTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + formMsgTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            Map<?, ?> map = ValidateFormEngine.obj2Map(codeinfo);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("VelocityContext - " + map.toString()));
            }
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, formMsgTemplate), createFileName);
            }
            catch (Exception var7) {
                logger.error((Object)"\u751f\u6210\u6587\u4ef6\u9519\u8bef:", (Throwable)var7);
            }
        }
    }
}

