/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.dialect.SQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;
import net.sf.hibernate.dialect.TypeNames;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.exception.SQLStateConverter;
import net.sf.hibernate.exception.ViolatedConstraintNameExtracter;
import net.sf.hibernate.sql.ANSICaseFragment;
import net.sf.hibernate.sql.ANSIJoinFragment;
import net.sf.hibernate.sql.CaseFragment;
import net.sf.hibernate.sql.JoinFragment;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Dialect {
    static final String DEFAULT_BATCH_SIZE = "15";
    static final String NO_BATCH = "0";
    private static final Map STANDARD_AGGREGATE_FUNCTIONS = new HashMap();
    private static final Log log;
    private final TypeNames typeNames = new TypeNames("$l");
    private final Properties properties = new Properties();
    private final Map sqlFunctions = new HashMap();
    public static final String QUOTE = "`\"[";
    public static final String CLOSED_QUOTE = "`\"]";
    private static final ViolatedConstraintNameExtracter EXTRACTER;
    static /* synthetic */ Class class$net$sf$hibernate$dialect$Dialect;

    protected Dialect() {
        log.info((Object)("Using dialect: " + this));
        this.sqlFunctions.putAll(STANDARD_AGGREGATE_FUNCTIONS);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getTypeName(int code) throws HibernateException {
        String result = this.typeNames.get(code);
        if (result == null) {
            throw new HibernateException("No default type mapping for (java.sql.Types) " + code);
        }
        return result;
    }

    public String getTypeName(int code, int length) throws HibernateException {
        String result = this.typeNames.get(code, length);
        if (result == null) {
            throw new HibernateException("No type mapping for (java.sql.Types) " + code + " of length " + length);
        }
        return result;
    }

    protected void registerFunction(String name, SQLFunction function) {
        this.sqlFunctions.put(name, function);
    }

    protected void registerColumnType(int code, int capacity, String name) {
        this.typeNames.put(code, capacity, name);
    }

    protected void registerColumnType(int code, String name) {
        this.typeNames.put(code, name);
    }

    public boolean hasAlterTable() {
        return true;
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return true;
    }

    public boolean supportsForUpdate() {
        return true;
    }

    public boolean supportsForUpdateOf() {
        return false;
    }

    public boolean supportsForUpdateNowait() {
        return false;
    }

    public boolean supportsUnique() {
        return true;
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    public String getAddColumnString() {
        throw new UnsupportedOperationException("No add column syntax supported by Dialect");
    }

    public String getDropForeignKeyString() {
        return " drop constraint ";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        return new StringBuffer(30).append(" add constraint ").append(constraintName).append(" foreign key (").append(StringHelper.join(", ", foreignKey)).append(") references ").append(referencedTable).toString();
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        return " add constraint " + constraintName + " primary key ";
    }

    public String getNullColumnString() {
        return "";
    }

    public boolean supportsIdentityColumns() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public String appendIdentitySelectToInsert(String insertSQL) {
        return null;
    }

    public String getIdentitySelectString() throws MappingException {
        throw new MappingException("Dialect does not support identity key generation");
    }

    public String getIdentityColumnString() throws MappingException {
        throw new MappingException("Dialect does not support identity key generation");
    }

    public String getIdentityInsertString() {
        return null;
    }

    public String getNoColumnsInsertString() {
        return "values ( )";
    }

    public String getSequenceNextValString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getCreateSequenceString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getDropSequenceString(String sequenceName) throws MappingException {
        throw new MappingException("Dialect does not support sequences");
    }

    public String getQuerySequencesString() {
        return null;
    }

    public static Dialect getDialect() throws HibernateException {
        String dialectName = Environment.getProperties().getProperty("hibernate.dialect");
        if (dialectName == null) {
            throw new HibernateException("The dialect was not set. Set the property hibernate.dialect.");
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    public static Dialect getDialect(Properties props) throws HibernateException {
        String dialectName = props.getProperty("hibernate.dialect");
        if (dialectName == null) {
            return Dialect.getDialect();
        }
        try {
            return (Dialect)ReflectHelper.classForName(dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", e);
        }
    }

    public final Properties getDefaultProperties() {
        return this.properties;
    }

    public String getCascadeConstraintsString() {
        return "";
    }

    public JoinFragment createOuterJoinFragment() {
        return new ANSIJoinFragment();
    }

    public CaseFragment createCaseFragment() {
        return new ANSICaseFragment();
    }

    public String getLowercaseFunction() {
        return "lower";
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public String getLimitString(String querySelect, boolean hasOffset) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    public String getLimitString(String querySelect, boolean hasOffset, int limit) {
        return this.getLimitString(querySelect, hasOffset);
    }

    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public final Map getFunctions() {
        return this.sqlFunctions;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public char getSchemaSeparator() {
        return '.';
    }

    public boolean supportsCheck() {
        return true;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new SQLStateConverter(this.getViolatedConstraintNameExtracter());
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        STANDARD_AGGREGATE_FUNCTIONS.put("count", new SQLFunction(){

            public Type getReturnType(Type columnType, Mapping mapping) {
                return Hibernate.INTEGER;
            }

            public boolean hasArguments() {
                return true;
            }

            public boolean hasParenthesesIfNoArguments() {
                return true;
            }
        });
        STANDARD_AGGREGATE_FUNCTIONS.put("avg", new SQLFunction(){

            public Type getReturnType(Type columnType, Mapping mapping) throws QueryException {
                int[] sqlTypes;
                try {
                    sqlTypes = columnType.sqlTypes(mapping);
                }
                catch (MappingException me) {
                    throw new QueryException(me);
                }
                if (sqlTypes.length != 1) {
                    throw new QueryException("multi-column type in avg()");
                }
                int sqlType = sqlTypes[0];
                if (sqlType == 4 || sqlType == -5 || sqlType == -6) {
                    return Hibernate.FLOAT;
                }
                return columnType;
            }

            public boolean hasArguments() {
                return true;
            }

            public boolean hasParenthesesIfNoArguments() {
                return true;
            }
        });
        STANDARD_AGGREGATE_FUNCTIONS.put("max", new StandardSQLFunction());
        STANDARD_AGGREGATE_FUNCTIONS.put("min", new StandardSQLFunction());
        STANDARD_AGGREGATE_FUNCTIONS.put("sum", new StandardSQLFunction());
        log = LogFactory.getLog((Class)(class$net$sf$hibernate$dialect$Dialect == null ? (class$net$sf$hibernate$dialect$Dialect = Dialect.class$("net.sf.hibernate.dialect.Dialect")) : class$net$sf$hibernate$dialect$Dialect));
        EXTRACTER = new ViolatedConstraintNameExtracter(){

            public String extractConstraintName(SQLException sqle) {
                return null;
            }
        };
    }
}

