/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.model.CodeInfo;
import com.miniframe.designer.model.CommCodeInfo;
import com.miniframe.designer.util.DesignerTools;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class TransServiceEngine
extends MiniVelocityEngine {
    private static final Logger logger = Logger.getLogger(TransServiceEngine.class);
    private String dataDir = "D:/workspace/com.miniframe.manager/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/";
    private String xmlFile = "D:/workspace/com.miniframe.manager/configsrc/applicationContext-comm.xml";
    private String xmlTemplate = "D:/workspace/com.miniframe.manager/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/xmlTemplate.vm";
    private String modelDir = "D:/workspace/com.miniframe.manager/generated/";
    private String modelTemplate = "D:/workspace/com.miniframe.manager/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/modelTemplate.vm";
    private String clientTemplate = "D:/workspace/com.miniframe.manager/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/clientTemplate.vm";
    private String testDir = "D:/workspace/com.miniframe.manager/commtest/";
    private String utilTemplate = "D:/workspace/com.miniframe.manager/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/utilTemplate.vm";
    private String testTemplate = "D:/workspace/com.miniframe.manager/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/testTemplate.vm";

    public static void main(String[] args) throws Exception {
        int i;
        Map map;
        TransServiceEngine engine = new TransServiceEngine();
        engine.setDataDir(MiniVelocityEngine.getDir("dataDir"));
        engine.setXmlFile(MiniVelocityEngine.getSysProperty("xmlFile"));
        engine.setXmlTemplate(MiniVelocityEngine.getSysProperty("xmlTemplate"));
        engine.setModelDir(MiniVelocityEngine.getDir("modelDir"));
        engine.setModelTemplate(MiniVelocityEngine.getSysProperty("modelTemplate"));
        engine.setClientTemplate(MiniVelocityEngine.getSysProperty("clientTemplate"));
        engine.setTestDir(MiniVelocityEngine.getDir("testDir"));
        engine.setUtilTemplate(MiniVelocityEngine.getSysProperty("utilTemplate"));
        engine.setTestTemplate(MiniVelocityEngine.getSysProperty("testTemplate"));
        List<CommCodeInfo> list = MiniVelocityEngine.findCommDesigner(engine.getDataDir());
        engine.xmlGenerator(list);
        List modelList = engine.getModelList(list);
        for (int i2 = 0; i2 < modelList.size(); ++i2) {
            map = (Map)modelList.get(i2);
            engine.modelGenerator(map);
        }
        List clientList = engine.getClientList(list);
        for (i = 0; i < clientList.size(); ++i) {
            map = (Map)clientList.get(i);
            engine.clientGenerator(map);
        }
        for (i = 0; i < clientList.size(); ++i) {
            map = (Map)clientList.get(i);
            String apater = (String)map.get("apater");
            if (apater == null) continue;
            engine.utilGenerator(map);
            engine.testGenerator(map);
        }
    }

    public void testGenerator(Map<String, String> map) {
        File file = new File(this.testTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.testTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            logger.error((Object)("\u751f\u6210\u6d4b\u8bd5\u5de5\u5177\u7c7b\u4ee3\u7801:" + map));
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String testFile = this.testDir + "com/miniframe/comm/" + map.get("apater").toLowerCase() + "/" + map.get("\u4ea4\u6613\u7f16\u7801").toUpperCase() + "Test.java";
                File file1 = new File(testFile);
                if (!file1.exists()) {
                    MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.testTemplate), testFile);
                }
            }
            catch (Exception var6) {
                logger.error((Object)"\u751f\u6210model\u6587\u4ef6\u9519\u8bef:", (Throwable)var6);
            }
        }
    }

    public void utilGenerator(Map<String, String> map) {
        File file = new File(this.utilTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.utilTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            logger.error((Object)("\u751f\u6210\u9002\u914d\u5668\u5de5\u5177\u7c7b\u4ee3\u7801:" + map));
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String utilFile = this.testDir + "com/miniframe/comm/" + map.get("apater").toLowerCase() + "/" + DesignerTools.capName(map.get("apater").toLowerCase()) + "Util.java";
                File file1 = new File(utilFile);
                if (!file1.exists()) {
                    MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.utilTemplate), utilFile);
                }
            }
            catch (Exception var6) {
                logger.error((Object)"\u751f\u6210model\u6587\u4ef6\u9519\u8bef:", (Throwable)var6);
            }
        }
    }

    public void clientGenerator(Map<String, String> map) {
        File file = new File(this.clientTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.clientTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            logger.error((Object)("\u751f\u6210\u5ba2\u6237\u7aef\u901a\u8baf\u6570\u636e:" + map));
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String clientFile = this.modelDir + "com/miniframe/generate/comm/" + map.get("apater").toLowerCase() + "/" + map.get("\u4ea4\u6613\u7f16\u7801").toUpperCase() + "Client.java";
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.clientTemplate), clientFile);
            }
            catch (Exception var5) {
                logger.error((Object)"\u751f\u6210model\u6587\u4ef6\u9519\u8bef:", (Throwable)var5);
            }
        }
    }

    public void modelGenerator(Map<String, String> map) {
        File file = new File(this.modelTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.modelTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String modelFile = this.modelDir + "com/miniframe/generate/business/system/model/" + map.get("\u4ea4\u6613\u7f16\u7801").toUpperCase() + "BaseModel.java";
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.modelTemplate), modelFile);
            }
            catch (Exception var5) {
                logger.error((Object)"\u751f\u6210model\u6587\u4ef6\u9519\u8bef:", (Throwable)var5);
            }
        }
    }

    public void xmlGenerator(List<CommCodeInfo> list) {
        File file = new File(this.xmlTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.xmlTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            VelocityContext ctx = new VelocityContext();
            logger.error((Object)("--->" + list));
            ArrayList mapList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                Map<?, ?> map = TransServiceEngine.obj2Map(list.get(i));
                mapList.add(map);
            }
            ctx.put("list", mapList);
            try {
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.xmlTemplate), this.xmlFile);
            }
            catch (Exception var7) {
                logger.error((Object)"\u751f\u6210xml\u9519\u8bef:", (Throwable)var7);
            }
        }
    }

    public List getModelList(List<CommCodeInfo> list) throws Exception {
        ArrayList transList = new ArrayList();
        HashMap<String, String> limitMap = new HashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            CommCodeInfo info = list.get(i);
            if (info.getMap().get("commType") == null) continue;
            String transHead = (String)((Map)info.getMap().get("assembleName")).get("\u8bbe\u7f6e\u503c");
            int k = transHead.indexOf("_");
            transHead = transHead.substring(k + 1);
            String transDir = (String)((Map)info.getMap().get("transDir")).get("\u8bbe\u7f6e\u503c");
            CodeInfo sortInfo = TransServiceEngine.getCodeInfo(transDir);
            String dirPath = this.dataDir;
            if (!dirPath.endsWith("/")) {
                dirPath = dirPath + "/";
            }
            dirPath = dirPath + "../\u901a\u8baf\u62a5\u6587/" + transDir + "/\u62a5\u6587\u4f53/";
            List<CodeInfo> list1 = MiniVelocityEngine.findDesigner(dirPath);
            for (int j = 0; j < list1.size(); ++j) {
                CodeInfo child = list1.get(j);
                String childCode = child.getCode();
                int m = childCode.indexOf("_");
                if (limitMap.get(childCode = childCode.substring(0, m).trim()) != null) continue;
                limitMap.put(childCode, "");
                HashMap<String, String> childMap = new HashMap<String, String>();
                childMap.put("\u4ea4\u6613\u7f16\u7801", childCode);
                childMap.put("\u4ea4\u6613\u540d\u79f0", child.getName());
                childMap.put("head", transHead);
                childMap.put("code", sortInfo.getCode().replace("_", "").toLowerCase().trim());
                childMap.put("name", sortInfo.getName());
                transList.add(childMap);
            }
        }
        return transList;
    }

    public List getClientList(List<CommCodeInfo> list) throws Exception {
        ArrayList transList = new ArrayList();
        HashMap<String, String> limitMap = new HashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            CommCodeInfo info = list.get(i);
            if (info.getMap().get("commType") == null || info.getMap().get("transmitter") == null) continue;
            String transHead = (String)((Map)info.getMap().get("assembleName")).get("\u8bbe\u7f6e\u503c");
            int k = transHead.indexOf("_");
            transHead = transHead.substring(k + 1);
            String transDir = (String)((Map)info.getMap().get("transDir")).get("\u8bbe\u7f6e\u503c");
            CodeInfo sortInfo = TransServiceEngine.getCodeInfo(transDir);
            String dirPath = this.dataDir;
            if (!dirPath.endsWith("/")) {
                dirPath = dirPath + "/";
            }
            dirPath = dirPath + "../\u901a\u8baf\u62a5\u6587/" + transDir + "/\u62a5\u6587\u4f53/";
            List<CodeInfo> list1 = MiniVelocityEngine.findDesigner(dirPath);
            for (int j = 0; j < list1.size(); ++j) {
                CodeInfo child = list1.get(j);
                String childCode = child.getCode();
                int m = childCode.indexOf("_");
                if (limitMap.get(childCode = childCode.substring(0, m).trim()) != null) continue;
                limitMap.put(childCode, "");
                HashMap<String, String> childMap = new HashMap<String, String>();
                childMap.put("\u4ea4\u6613\u7f16\u7801", childCode);
                childMap.put("\u4ea4\u6613\u540d\u79f0", child.getName());
                childMap.put("head", transHead);
                childMap.put("apater", info.getCode().trim());
                childMap.put("code", sortInfo.getCode().replace("_", "").toLowerCase().trim());
                childMap.put("name", sortInfo.getName());
                transList.add(childMap);
            }
        }
        return transList;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getXmlFile() {
        return this.xmlFile;
    }

    public void setXmlFile(String xmlFile) {
        this.xmlFile = xmlFile;
    }

    public String getXmlTemplate() {
        return this.xmlTemplate;
    }

    public void setXmlTemplate(String xmlTemplate) {
        this.xmlTemplate = xmlTemplate;
    }

    public String getModelDir() {
        return this.modelDir;
    }

    public void setModelDir(String modelDir) {
        this.modelDir = modelDir;
    }

    public String getModelTemplate() {
        return this.modelTemplate;
    }

    public void setModelTemplate(String modelTemplate) {
        this.modelTemplate = modelTemplate;
    }

    public String getClientTemplate() {
        return this.clientTemplate;
    }

    public void setClientTemplate(String clientTemplate) {
        this.clientTemplate = clientTemplate;
    }

    public String getTestDir() {
        return this.testDir;
    }

    public void setTestDir(String testDir) {
        this.testDir = testDir;
    }

    public String getUtilTemplate() {
        return this.utilTemplate;
    }

    public void setUtilTemplate(String utilTemplate) {
        this.utilTemplate = utilTemplate;
    }

    public String getTestTemplate() {
        return this.testTemplate;
    }

    public void setTestTemplate(String testTemplate) {
        this.testTemplate = testTemplate;
    }
}

