/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.model.CodeInfo;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class MenuVelocityEngine
extends MiniVelocityEngine {
    private static final Logger logger = Logger.getLogger(MenuVelocityEngine.class);
    private static final String DATADIR = "dataDir";
    private static final String SQLFILE = "sqlFile";
    private static final String SQLTEMPLATE = "sqlTemplate";

    public static void main(String[] args) throws Exception {
        List<CodeInfo> list = MenuVelocityEngine.findDesigner(MenuVelocityEngine.getDir(DATADIR));
        if (list.size() > 0) {
            CodeInfo info = list.get(0);
            MenuVelocityEngine.sqlGenerator(info.getList());
        }
    }

    public static void sqlGenerator(List<Map<String, String>> list) {
        String sqlTemplate = MenuVelocityEngine.getSysProperty(SQLTEMPLATE);
        File file = new File(sqlTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + sqlTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("list) - " + list.toString()));
            }
            VelocityContext ctx = new VelocityContext();
            ctx.put("list", list);
            try {
                String sqlFile = MenuVelocityEngine.getSysProperty(SQLFILE);
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, sqlTemplate), sqlFile);
            }
            catch (Exception var5) {
                logger.error((Object)"\u751f\u6210\u679a\u4e3e\u7c7b\u9519\u8bef:", (Throwable)var5);
            }
        }
    }
}

