/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerInterface;
import org.mybatis.generator.internal.util.StringUtility;

public class Interface
extends InnerInterface
implements CompilationUnit {
    private Set<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
    private Set<String> staticImports;
    private List<String> fileCommentLines = new ArrayList<String>();

    public Interface(FullyQualifiedJavaType type) {
        super(type);
        this.staticImports = new TreeSet<String>();
    }

    public Interface(String type) {
        this(new FullyQualifiedJavaType(type));
    }

    @Override
    public Set<FullyQualifiedJavaType> getImportedTypes() {
        return this.importedTypes;
    }

    @Override
    public void addImportedType(FullyQualifiedJavaType importedType) {
        if (importedType.isExplicitlyImported() && !importedType.getPackageName().equals(this.getType().getPackageName())) {
            this.importedTypes.add(importedType);
        }
    }

    @Override
    public String getFormattedContent() {
        return this.getFormattedContent(0, this);
    }

    @Override
    public String getFormattedContent(int indentLevel, CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        for (String commentLine : this.fileCommentLines) {
            sb.append(commentLine);
            OutputUtilities.newLine(sb);
        }
        if (StringUtility.stringHasValue(this.getType().getPackageName())) {
            sb.append("package ");
            sb.append(this.getType().getPackageName());
            sb.append(';');
            OutputUtilities.newLine(sb);
            OutputUtilities.newLine(sb);
        }
        for (String staticImport : this.staticImports) {
            sb.append("import static ");
            sb.append(staticImport);
            sb.append(';');
            OutputUtilities.newLine(sb);
        }
        if (this.staticImports.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        Set<String> importStrings = OutputUtilities.calculateImports(this.importedTypes);
        for (String importString : importStrings) {
            sb.append(importString);
            OutputUtilities.newLine(sb);
        }
        if (importStrings.size() > 0) {
            OutputUtilities.newLine(sb);
        }
        sb.append(super.getFormattedContent(0, this));
        return sb.toString();
    }

    @Override
    public void addFileCommentLine(String commentLine) {
        this.fileCommentLines.add(commentLine);
    }

    @Override
    public List<String> getFileCommentLines() {
        return this.fileCommentLines;
    }

    @Override
    public void addImportedTypes(Set<FullyQualifiedJavaType> importedTypes) {
        this.importedTypes.addAll(importedTypes);
    }

    @Override
    public Set<String> getStaticImports() {
        return this.staticImports;
    }

    @Override
    public void addStaticImport(String staticImport) {
        this.staticImports.add(staticImport);
    }

    @Override
    public void addStaticImports(Set<String> staticImports) {
        this.staticImports.addAll(staticImports);
    }
}

