/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis2.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.ibator.api.CommentGenerator;
import org.apache.ibatis.ibator.api.FullyQualifiedTable;
import org.apache.ibatis.ibator.api.IbatorPlugin;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.dom.java.CompilationUnit;
import org.apache.ibatis.ibator.api.dom.java.Field;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.JavaVisibility;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.api.dom.java.TopLevelClass;
import org.apache.ibatis.ibator.generator.AbstractJavaGenerator;
import org.apache.ibatis.ibator.generator.RootClassInfo;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseRecordGenerator
extends AbstractJavaGenerator {
    @Override
    public List<CompilationUnit> getCompilationUnits() {
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        this.progressCallback.startTask(Messages.getString("Progress.8", table.toString()));
        IbatorPlugin plugins = this.ibatorContext.getPlugins();
        CommentGenerator commentGenerator = this.ibatorContext.getCommentGenerator();
        TopLevelClass topLevelClass = new TopLevelClass(this.introspectedTable.getBaseRecordType());
        topLevelClass.setVisibility(JavaVisibility.PUBLIC);
        commentGenerator.addClassComment(topLevelClass, this.introspectedTable);
        FullyQualifiedJavaType superClass = this.getSuperClass();
        if (superClass != null) {
            topLevelClass.setSuperClass(superClass);
            topLevelClass.addImportedType(superClass);
        }
        List<IntrospectedColumn> introspectedColumns = this.includePrimaryKeyColumns() ? (this.includeBLOBColumns() ? this.introspectedTable.getAllColumns() : this.introspectedTable.getNonBLOBColumns()) : (this.includeBLOBColumns() ? this.introspectedTable.getNonPrimaryKeyColumns() : this.introspectedTable.getBaseColumns());
        String rootClass = this.getRootClass();
        for (IntrospectedColumn introspectedColumn : introspectedColumns) {
            Method method;
            if (RootClassInfo.getInstance(rootClass, this.warnings).containsProperty(introspectedColumn)) continue;
            Field field = this.getJavaBeansField(introspectedColumn);
            if (plugins.modelFieldGenerated(field, topLevelClass, introspectedColumn, this.introspectedTable, IbatorPlugin.ModelClassType.BASE_RECORD)) {
                topLevelClass.addField(field);
                topLevelClass.addImportedType(field.getType());
            }
            if (plugins.modelGetterMethodGenerated(method = this.getJavaBeansGetter(introspectedColumn), topLevelClass, introspectedColumn, this.introspectedTable, IbatorPlugin.ModelClassType.BASE_RECORD)) {
                topLevelClass.addMethod(method);
            }
            if (!plugins.modelSetterMethodGenerated(method = this.getJavaBeansSetter(introspectedColumn), topLevelClass, introspectedColumn, this.introspectedTable, IbatorPlugin.ModelClassType.BASE_RECORD)) continue;
            topLevelClass.addMethod(method);
        }
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        if (this.ibatorContext.getPlugins().modelBaseRecordClassGenerated(topLevelClass, this.introspectedTable)) {
            answer.add(topLevelClass);
        }
        return answer;
    }

    private FullyQualifiedJavaType getSuperClass() {
        String rootClass;
        FullyQualifiedJavaType superClass = this.introspectedTable.getRules().generatePrimaryKeyClass() ? new FullyQualifiedJavaType(this.introspectedTable.getPrimaryKeyType()) : ((rootClass = this.getRootClass()) != null ? new FullyQualifiedJavaType(rootClass) : null);
        return superClass;
    }

    private boolean includePrimaryKeyColumns() {
        return !this.introspectedTable.getRules().generatePrimaryKeyClass() && this.introspectedTable.hasPrimaryKeyColumns();
    }

    private boolean includeBLOBColumns() {
        return !this.introspectedTable.getRules().generateRecordWithBLOBsClass() && this.introspectedTable.hasBLOBColumns();
    }
}

