/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AbstractCriterion;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.StringHelper;

public class SQLCriterion
extends AbstractCriterion {
    private final String sql;
    private final TypedValue[] typedValues;

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias, Map aliasClasses) throws HibernateException {
        return StringHelper.replace(this.sql, "{alias}", alias);
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass, Map aliasClasses) throws HibernateException {
        return this.typedValues;
    }

    public String toString() {
        return this.sql;
    }

    SQLCriterion(String sql, Object[] values, Type[] types) {
        this.sql = sql;
        this.typedValues = new TypedValue[values.length];
        for (int i = 0; i < this.typedValues.length; ++i) {
            this.typedValues[i] = new TypedValue(types[i], values[i]);
        }
    }
}

