/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.config;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.ibator.api.CommentGenerator;
import org.apache.ibatis.ibator.api.GeneratedJavaFile;
import org.apache.ibatis.ibator.api.GeneratedXmlFile;
import org.apache.ibatis.ibator.api.IbatorPlugin;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.JavaTypeResolver;
import org.apache.ibatis.ibator.api.ProgressCallback;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.config.CommentGeneratorConfiguration;
import org.apache.ibatis.ibator.config.DAOGeneratorConfiguration;
import org.apache.ibatis.ibator.config.IbatorPluginConfiguration;
import org.apache.ibatis.ibator.config.JDBCConnectionConfiguration;
import org.apache.ibatis.ibator.config.JavaModelGeneratorConfiguration;
import org.apache.ibatis.ibator.config.JavaTypeResolverConfiguration;
import org.apache.ibatis.ibator.config.ModelType;
import org.apache.ibatis.ibator.config.PropertyHolder;
import org.apache.ibatis.ibator.config.SqlMapGeneratorConfiguration;
import org.apache.ibatis.ibator.config.TableConfiguration;
import org.apache.ibatis.ibator.internal.IbatorObjectFactory;
import org.apache.ibatis.ibator.internal.IbatorPluginAggregator;
import org.apache.ibatis.ibator.internal.db.ConnectionFactory;
import org.apache.ibatis.ibator.internal.db.DatabaseIntrospector;
import org.apache.ibatis.ibator.internal.util.StringUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IbatorContext
extends PropertyHolder {
    private String id;
    public static JDBCConnectionConfiguration jdbcConnectionConfiguration;
    private SqlMapGeneratorConfiguration sqlMapGeneratorConfiguration;
    private JavaTypeResolverConfiguration javaTypeResolverConfiguration;
    private JavaModelGeneratorConfiguration javaModelGeneratorConfiguration;
    private DAOGeneratorConfiguration daoGeneratorConfiguration;
    private ArrayList<TableConfiguration> tableConfigurations;
    private ModelType defaultModelType;
    private String beginningDelimiter = "\"";
    private String endingDelimiter = "\"";
    private boolean suppressTypeWarnings;
    private CommentGeneratorConfiguration commentGeneratorConfiguration;
    private CommentGenerator commentGenerator;
    private IbatorPluginAggregator pluginAggregator;
    private List<IbatorPluginConfiguration> pluginConfigurations;
    private String targetRuntime;
    private String introspectedColumnImpl;
    private Boolean autoDelimitKeywords;
    private List<IntrospectedTable> introspectedTables;

    public IbatorContext(ModelType defaultModelType) {
        this.defaultModelType = defaultModelType == null ? ModelType.CONDITIONAL : defaultModelType;
        this.tableConfigurations = new ArrayList();
        this.pluginConfigurations = new ArrayList<IbatorPluginConfiguration>();
    }

    public void addTableConfiguration(TableConfiguration tc) {
        this.tableConfigurations.add(tc);
    }

    public JDBCConnectionConfiguration getJdbcConnectionConfiguration() {
        return jdbcConnectionConfiguration;
    }

    public DAOGeneratorConfiguration getDaoGeneratorConfiguration() {
        return this.daoGeneratorConfiguration;
    }

    public JavaModelGeneratorConfiguration getJavaModelGeneratorConfiguration() {
        return this.javaModelGeneratorConfiguration;
    }

    public JavaTypeResolverConfiguration getJavaTypeResolverConfiguration() {
        return this.javaTypeResolverConfiguration;
    }

    public SqlMapGeneratorConfiguration getSqlMapGeneratorConfiguration() {
        return this.sqlMapGeneratorConfiguration;
    }

    public void addPluginConfiguration(IbatorPluginConfiguration ibatorPluginConfiguration) {
        this.pluginConfigurations.add(ibatorPluginConfiguration);
    }

    public void validate(List<String> errors) {
        if (!StringUtility.stringHasValue(this.id)) {
            errors.add(Messages.getString("ValidationError.16"));
        }
        if (jdbcConnectionConfiguration == null) {
            errors.add(Messages.getString("ValidationError.10", this.id));
        } else {
            jdbcConnectionConfiguration.validate(errors);
        }
        if (this.javaModelGeneratorConfiguration == null) {
            errors.add(Messages.getString("ValidationError.8", this.id));
        } else {
            this.javaModelGeneratorConfiguration.validate(errors, this.id);
        }
        if (this.sqlMapGeneratorConfiguration == null) {
            errors.add(Messages.getString("ValidationError.9", this.id));
        } else {
            this.sqlMapGeneratorConfiguration.validate(errors, this.id);
        }
        if (this.daoGeneratorConfiguration != null) {
            this.daoGeneratorConfiguration.validate(errors, this.id);
        }
        if (this.tableConfigurations.size() == 0) {
            errors.add(Messages.getString("ValidationError.3", this.id));
        } else {
            int i = 0;
            while (i < this.tableConfigurations.size()) {
                TableConfiguration tc = this.tableConfigurations.get(i);
                tc.validate(errors, i);
                ++i;
            }
        }
        for (IbatorPluginConfiguration ibatorPluginConfiguration : this.pluginConfigurations) {
            ibatorPluginConfiguration.validate(errors, this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDaoGeneratorConfiguration(DAOGeneratorConfiguration daoGeneratorConfiguration) {
        this.daoGeneratorConfiguration = daoGeneratorConfiguration;
    }

    public void setJavaModelGeneratorConfiguration(JavaModelGeneratorConfiguration javaModelGeneratorConfiguration) {
        this.javaModelGeneratorConfiguration = javaModelGeneratorConfiguration;
    }

    public void setJavaTypeResolverConfiguration(JavaTypeResolverConfiguration javaTypeResolverConfiguration) {
        this.javaTypeResolverConfiguration = javaTypeResolverConfiguration;
    }

    public void setJdbcConnectionConfiguration(JDBCConnectionConfiguration jdbcConnectionConfiguration) {
        IbatorContext.jdbcConnectionConfiguration = jdbcConnectionConfiguration;
    }

    public void setSqlMapGeneratorConfiguration(SqlMapGeneratorConfiguration sqlMapGeneratorConfiguration) {
        this.sqlMapGeneratorConfiguration = sqlMapGeneratorConfiguration;
    }

    public ModelType getDefaultModelType() {
        return this.defaultModelType;
    }

    public XmlElement toXmlElement() {
        XmlElement xmlElement = new XmlElement("ibatorContext");
        if (this.defaultModelType != ModelType.CONDITIONAL) {
            xmlElement.addAttribute(new Attribute("defaultModelType", this.defaultModelType.getModelType()));
        }
        if (StringUtility.stringHasValue(this.introspectedColumnImpl)) {
            xmlElement.addAttribute(new Attribute("introspectedColumnImpl", this.introspectedColumnImpl));
        }
        if (StringUtility.stringHasValue(this.targetRuntime)) {
            xmlElement.addAttribute(new Attribute("targetRuntime", this.targetRuntime));
        }
        this.addPropertyXmlElements(xmlElement);
        if (this.commentGeneratorConfiguration != null) {
            xmlElement.addElement(this.commentGeneratorConfiguration.toXmlElement());
        }
        if (jdbcConnectionConfiguration != null) {
            xmlElement.addElement(jdbcConnectionConfiguration.toXmlElement());
        }
        if (this.javaTypeResolverConfiguration != null) {
            xmlElement.addElement(this.javaTypeResolverConfiguration.toXmlElement());
        }
        if (this.javaModelGeneratorConfiguration != null) {
            xmlElement.addElement(this.javaModelGeneratorConfiguration.toXmlElement());
        }
        if (this.sqlMapGeneratorConfiguration != null) {
            xmlElement.addElement(this.sqlMapGeneratorConfiguration.toXmlElement());
        }
        if (this.daoGeneratorConfiguration != null) {
            xmlElement.addElement(this.daoGeneratorConfiguration.toXmlElement());
        }
        for (TableConfiguration tableConfiguration : this.tableConfigurations) {
            xmlElement.addElement(tableConfiguration.toXmlElement());
        }
        return xmlElement;
    }

    public List<TableConfiguration> getTableConfigurations() {
        return this.tableConfigurations;
    }

    public String getBeginningDelimiter() {
        return this.beginningDelimiter;
    }

    public String getEndingDelimiter() {
        return this.endingDelimiter;
    }

    @Override
    public void addProperty(String name, String value) {
        super.addProperty(name, value);
        if ("suppressTypeWarnings".equals(name)) {
            this.suppressTypeWarnings = StringUtility.isTrue(value);
        } else if ("beginningDelimiter".equals(name)) {
            this.beginningDelimiter = value;
        } else if ("endingDelimiter".equals(name)) {
            this.endingDelimiter = value;
        } else if ("autoDelimitKeywords".equals(name) && StringUtility.stringHasValue(value)) {
            this.autoDelimitKeywords = new Boolean(StringUtility.isTrue(value));
        }
    }

    public CommentGenerator getCommentGenerator() {
        if (this.commentGenerator == null) {
            this.commentGenerator = IbatorObjectFactory.createCommentGenerator(this);
        }
        return this.commentGenerator;
    }

    public CommentGeneratorConfiguration getCommentGeneratorConfiguration() {
        return this.commentGeneratorConfiguration;
    }

    public void setCommentGeneratorConfiguration(CommentGeneratorConfiguration commentGeneratorConfiguration) {
        this.commentGeneratorConfiguration = commentGeneratorConfiguration;
    }

    public IbatorPlugin getPlugins() {
        return this.pluginAggregator;
    }

    public String getTargetRuntime() {
        return this.targetRuntime;
    }

    public void setTargetRuntime(String targetRuntime) {
        this.targetRuntime = targetRuntime;
    }

    public String getIntrospectedColumnImpl() {
        return this.introspectedColumnImpl;
    }

    public void setIntrospectedColumnImpl(String introspectedColumnImpl) {
        this.introspectedColumnImpl = introspectedColumnImpl;
    }

    public boolean getSuppressTypeWarnings(IntrospectedTable introspectedTable) {
        return this.suppressTypeWarnings && !introspectedTable.isJava5Targeted();
    }

    public int getIntrospectionSteps() {
        int steps = 0;
        ++steps;
        return steps += this.tableConfigurations.size() * 1;
    }

    public void introspectTables(ProgressCallback callback, List<String> warnings, Set<String> fullyQualifiedTableNames) throws SQLException, InterruptedException {
        this.introspectedTables = new ArrayList<IntrospectedTable>();
        JavaTypeResolver javaTypeResolver = IbatorObjectFactory.createJavaTypeResolver(this, warnings);
        Connection connection = null;
        try {
            callback.startTask(Messages.getString("Progress.0"));
            connection = this.getConnection();
            DatabaseIntrospector databaseIntrospector = new DatabaseIntrospector(this, connection.getMetaData(), javaTypeResolver, warnings);
            for (TableConfiguration tc : this.tableConfigurations) {
                String tableName = StringUtility.composeFullyQualifiedTableName(tc.getCatalog(), tc.getSchema(), tc.getTableName(), '.');
                if (fullyQualifiedTableNames != null && fullyQualifiedTableNames.size() > 0 && !fullyQualifiedTableNames.contains(tableName)) continue;
                if (!tc.areAnyStatementsEnabled()) {
                    warnings.add(Messages.getString("Warning.0", tableName));
                    continue;
                }
                callback.startTask(Messages.getString("Progress.1", tableName));
                List<IntrospectedTable> tables = databaseIntrospector.introspectTables(tc);
                if (tables != null) {
                    this.introspectedTables.addAll(tables);
                }
                callback.checkCancel();
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
    }

    public int getGenerationSteps() {
        int steps = 0;
        if (this.introspectedTables != null) {
            for (IntrospectedTable introspectedTable : this.introspectedTables) {
                steps += introspectedTable.getGenerationSteps();
            }
        }
        return steps;
    }

    public void generateFiles(ProgressCallback callback, List<GeneratedJavaFile> generatedJavaFiles, List<GeneratedXmlFile> generatedXmlFiles, List<String> warnings) throws InterruptedException {
        this.pluginAggregator = new IbatorPluginAggregator();
        for (IbatorPluginConfiguration ibatorPluginConfiguration : this.pluginConfigurations) {
            IbatorPlugin plugin = IbatorObjectFactory.createIbatorPlugin(this, ibatorPluginConfiguration);
            if (plugin.validate(warnings)) {
                this.pluginAggregator.addPlugin(plugin);
                continue;
            }
            warnings.add(Messages.getString("Warning.24", ibatorPluginConfiguration.getConfigurationType(), this.id));
        }
        if (this.introspectedTables != null) {
            for (IntrospectedTable introspectedTable : this.introspectedTables) {
                callback.checkCancel();
                introspectedTable.initialize();
                introspectedTable.calculateGenerators(warnings, callback);
                generatedJavaFiles.addAll(introspectedTable.getGeneratedJavaFiles());
                generatedXmlFiles.addAll(introspectedTable.getGeneratedXmlFiles());
                generatedJavaFiles.addAll(this.pluginAggregator.contextGenerateAdditionalJavaFiles(introspectedTable));
                generatedXmlFiles.addAll(this.pluginAggregator.contextGenerateAdditionalXmlFiles(introspectedTable));
            }
        }
        generatedJavaFiles.addAll(this.pluginAggregator.contextGenerateAdditionalJavaFiles());
        generatedXmlFiles.addAll(this.pluginAggregator.contextGenerateAdditionalXmlFiles());
    }

    private Connection getConnection() throws SQLException {
        Connection connection = ConnectionFactory.getInstance().getConnection(jdbcConnectionConfiguration);
        return connection;
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public boolean autoDelimitKeywords() {
        return this.autoDelimitKeywords != null && this.autoDelimitKeywords != false;
    }
}

