/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.internal;

import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.ibator.api.CommentGenerator;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.dom.java.CompilationUnit;
import org.apache.ibatis.ibator.api.dom.java.Field;
import org.apache.ibatis.ibator.api.dom.java.InnerClass;
import org.apache.ibatis.ibator.api.dom.java.InnerEnum;
import org.apache.ibatis.ibator.api.dom.java.JavaElement;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.api.dom.java.Parameter;
import org.apache.ibatis.ibator.api.dom.xml.TextElement;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.internal.util.StringUtility;

public class DefaultCommentGenerator
implements CommentGenerator {
    private Properties properties = new Properties();
    private boolean suppressDate = false;

    private String getIntrospectedColumnComment(IntrospectedColumn introspectedColumn) {
        String columnComment = introspectedColumn.getActualColumnName();
        if (introspectedColumn.getRemarks() != null) {
            columnComment = String.valueOf(columnComment) + "," + introspectedColumn.getRemarks();
        }
        columnComment = introspectedColumn.getScale() > 0 ? String.valueOf(columnComment) + "," + introspectedColumn.getJdbcTypeName() + "(" + introspectedColumn.getLength() + "." + introspectedColumn.getScale() + ")" : String.valueOf(columnComment) + "," + introspectedColumn.getJdbcTypeName() + "(" + introspectedColumn.getLength() + ")";
        columnComment = introspectedColumn.isNullable() ? String.valueOf(columnComment) + ",ISNULL: Y " : String.valueOf(columnComment) + ",ISNULL: N ";
        if (introspectedColumn.getDefaultValue() != null) {
            columnComment = String.valueOf(columnComment) + ",default:" + introspectedColumn.getDefaultValue();
        }
        return columnComment;
    }

    public void addFieldComment(Field field, IntrospectedTable table, IntrospectedColumn introspectedColumn) {
        field.addJavaDocLine("/**");
        String tmp = this.getIntrospectedColumnComment(introspectedColumn);
        if (tmp != null && !tmp.trim().equals("")) {
            field.addJavaDocLine(" * " + tmp);
        }
        this.addIbatorJavadocTag(field);
        field.addJavaDocLine(" */");
    }

    public void addFieldComment(Field field, IntrospectedTable table) {
        StringBuilder sb = new StringBuilder();
        field.addJavaDocLine("/**");
        if (table != null && table.getRemarks() != null) {
            sb.append(" * " + table.getRemarks());
            field.addJavaDocLine(sb.toString());
        }
        this.addIbatorJavadocTag(field);
        field.addJavaDocLine(" */");
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable table) {
        StringBuilder sb = new StringBuilder();
        innerClass.addJavaDocLine("/**");
        if (table != null && table.getRemarks() != null) {
            sb.append(" * " + table.getRemarks());
            innerClass.addJavaDocLine(sb.toString());
        }
        this.addIbatorJavadocTag(innerClass);
        innerClass.addJavaDocLine(" */");
    }

    public void addEnumComment(InnerEnum innerEnum, IntrospectedTable table) {
        StringBuilder sb = new StringBuilder();
        innerEnum.addJavaDocLine("/**");
        if (table != null && table.getRemarks() != null) {
            sb.append(" * " + table.getRemarks());
            innerEnum.addJavaDocLine(sb.toString());
        }
        this.addIbatorJavadocTag(innerEnum);
        innerEnum.addJavaDocLine(" */");
    }

    public void addGetterComment(Method method, IntrospectedTable table, IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.setLength(0);
        sb.append(" * @return ");
        sb.append(this.getIntrospectedColumnComment(introspectedColumn));
        method.addJavaDocLine(sb.toString());
        this.addIbatorJavadocTag(method);
        method.addJavaDocLine(" */");
    }

    public void addSetterComment(Method method, IntrospectedTable table, IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        sb.setLength(0);
        Parameter parm = method.getParameters().get(0);
        sb.setLength(0);
        sb.append(" * @param ");
        sb.append(parm.getName());
        sb.append(",");
        sb.append(this.getIntrospectedColumnComment(introspectedColumn));
        method.addJavaDocLine(sb.toString());
        this.addIbatorJavadocTag(method);
        method.addJavaDocLine(" */");
    }

    public void addGeneralMethodComment(Method method, String methodComment) {
        StringBuilder sb = new StringBuilder();
        method.addJavaDocLine("/**");
        if (methodComment != null) {
            sb.append(" * " + methodComment);
            method.addJavaDocLine(sb.toString());
        }
        this.addIbatorJavadocTag(method);
        method.addJavaDocLine(" */");
    }

    public void addJavaFileComment(CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        sb.append("/*\r\n");
        sb.append("*  Copyright 2010 The YAPULAN Software Foundation\r\n");
        sb.append("*\r\n");
        sb.append("*  Licensed under the YAPULAN License, Version 2.0 (the \"License\");\r\n");
        sb.append("*/\r\n");
        compilationUnit.addFileCommentLine(sb.toString());
    }

    public void addComment(XmlElement xmlElement) {
    }

    public void addRootComment(XmlElement rootElement) {
        rootElement.addElement(new TextElement("<!-- \u8b66\u544a - \u4ee5\u4e0b\u7684SQLMap\u914d\u7f6e\u6587\u4ef6\u7531\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\uff0c\u8bf7\u52ff\u4fee\u6539\uff0c\u5426\u5219\u7cfb\u7edf\u91cd\u65b0\u751f\u6210\u540e\u5c06\u4f1a\u8986\u76d6\u3002-->"));
    }

    public void addConfigurationProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        this.suppressDate = StringUtility.isTrue(properties.getProperty("suppressDate"));
    }

    protected void addIbatorJavadocTag(JavaElement javaElement) {
        StringBuilder sb = new StringBuilder();
        sb.append(" * ");
        sb.append("@generated");
        javaElement.addJavaDocLine(sb.toString());
    }
}

