/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.model.CodeInfo;
import com.miniframe.designer.util.DesignerTools;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class StaticVelocityEngine
extends MiniVelocityEngine {
    private static final Logger logger = Logger.getLogger(StaticVelocityEngine.class);
    private static final String DATADIR = "dataDir";
    private static final String JAVADIR = "javaDir";
    private static final String PACKAGE = "packAge";
    private static final String JAVATEMPLATE = "javaTemplate";

    public static void main(String[] args) throws Exception {
        List<CodeInfo> list = StaticVelocityEngine.findDesigner(StaticVelocityEngine.getDir(DATADIR));
        for (int i = 0; i < list.size(); ++i) {
            StaticVelocityEngine.javaGenerator(list.get(i));
        }
    }

    public static void javaGenerator(CodeInfo codeinfo) {
        String javaTemplate = StaticVelocityEngine.getSysProperty(JAVATEMPLATE);
        File file = new File(javaTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + javaTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            Map<?, ?> map = StaticVelocityEngine.obj2Map(codeinfo);
            String packAge = StaticVelocityEngine.getSysProperty(PACKAGE);
            map.put(PACKAGE, packAge);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("VelocityContext - " + map.toString()));
            }
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String javaDir = StaticVelocityEngine.getDir(JAVADIR);
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, javaTemplate), javaDir + packAge.replace(".", "/") + "/AppGlobalVariable" + DesignerTools.capName(codeinfo.getCode()) + ".java");
            }
            catch (Exception var7) {
                logger.error((Object)"\u751f\u6210\u679a\u4e3e\u7c7b\u9519\u8bef:", (Throwable)var7);
            }
        }
    }
}

