/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaDomUtils;

public class TypeParameter {
    private String name;
    private List<FullyQualifiedJavaType> extendsTypes;

    public TypeParameter(String name) {
        this(name, new ArrayList<FullyQualifiedJavaType>());
    }

    public TypeParameter(String name, List<FullyQualifiedJavaType> extendsTypes) {
        this.name = name;
        this.extendsTypes = extendsTypes;
    }

    public String getName() {
        return this.name;
    }

    public List<FullyQualifiedJavaType> getExtendsTypes() {
        return this.extendsTypes;
    }

    public String getFormattedContent(CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (!this.extendsTypes.isEmpty()) {
            sb.append(" extends ");
            boolean addAnd = false;
            for (FullyQualifiedJavaType type : this.extendsTypes) {
                if (addAnd) {
                    sb.append(" & ");
                } else {
                    addAnd = true;
                }
                sb.append(JavaDomUtils.calculateTypeName(compilationUnit, type));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.getFormattedContent(null);
    }
}

