/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.config;

import java.util.List;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.config.PropertyHolder;
import org.apache.ibatis.ibator.internal.util.StringUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaModelGeneratorConfiguration
extends PropertyHolder {
    private String targetPackage;
    private String targetProject;

    public String getTargetProject() {
        return this.targetProject;
    }

    public void setTargetProject(String targetProject) {
        this.targetProject = targetProject;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public XmlElement toXmlElement() {
        XmlElement answer = new XmlElement("javaModelGenerator");
        if (this.targetPackage != null) {
            answer.addAttribute(new Attribute("targetPackage", this.targetPackage));
        }
        if (this.targetProject != null) {
            answer.addAttribute(new Attribute("targetProject", this.targetProject));
        }
        this.addPropertyXmlElements(answer);
        return answer;
    }

    public void validate(List<String> errors, String contextId) {
        if (!StringUtility.stringHasValue(this.targetProject)) {
            errors.add(Messages.getString("ValidationError.0", contextId));
        }
        if (!StringUtility.stringHasValue(this.targetPackage)) {
            errors.add(Messages.getString("ValidationError.12", "JavaModelGenerator", contextId));
        }
    }
}

