/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.model.CodeInfo;
import com.miniframe.designer.model.CommCodeInfo;
import com.miniframe.designer.util.DesignerTools;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class JsonTransServiceEngine
extends MiniVelocityEngine {
    private static final Logger logger = Logger.getLogger(JsonTransServiceEngine.class);
    private String project = "E:\\dev\\info\\service";
    private String dataDir = this.project + "/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/";
    private String xmlDir = this.project + "/clientcfg/";
    private String xmlTemplate = this.project + "/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/xmlTemplate.vm";
    private String modelDir = this.project + "/generated/";
    private String modelTemplate = this.project + "/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/modelTemplate.vm";
    private String clientTemplate = this.project + "/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/clientTemplate.vm";
    private String testDir = this.project + "/commtest/";
    private String utilTemplate = this.project + "/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/utilTemplate.vm";
    private String testTemplate = this.project + "/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/testTemplate.vm";
    private String serviceName = "Service";
    private String feignTemplate;
    private String feignDir = this.project + "/feign";

    public JsonTransServiceEngine() {
        this.feignTemplate = this.project + "/\u7cfb\u7edf\u8bbe\u8ba1/\u901a\u4fe1\u8bbe\u8ba1/\u901a\u8baf\u63a5\u53e3/build/feignTemplate.vm";
    }

    public static void main(String[] args) throws Exception {
        int i;
        Map map;
        JsonTransServiceEngine engine = new JsonTransServiceEngine();
        engine.setDataDir(MiniVelocityEngine.getDir("dataDir"));
        engine.setXmlDir(MiniVelocityEngine.getSysProperty("xmlDir"));
        engine.setXmlTemplate(MiniVelocityEngine.getSysProperty("xmlTemplate"));
        engine.setModelDir(MiniVelocityEngine.getDir("modelDir"));
        engine.setModelTemplate(MiniVelocityEngine.getSysProperty("modelTemplate"));
        engine.setClientTemplate(MiniVelocityEngine.getSysProperty("clientTemplate"));
        engine.setTestDir(MiniVelocityEngine.getDir("testDir"));
        engine.setUtilTemplate(MiniVelocityEngine.getSysProperty("utilTemplate"));
        engine.setTestTemplate(MiniVelocityEngine.getSysProperty("testTemplate"));
        engine.setServiceName(MiniVelocityEngine.getSysProperty("serviceName"));
        engine.setFeignTemplate(MiniVelocityEngine.getSysProperty("feignTemplate"));
        engine.setFeignDir(MiniVelocityEngine.getSysProperty("feignDir"));
        List<CommCodeInfo> list = MiniVelocityEngine.findCommDesigner(engine.getDataDir());
        engine.xmlGenerator(list);
        engine.feignGenerator(list);
        List modelList = engine.getModelList(list);
        for (int i2 = 0; i2 < modelList.size(); ++i2) {
            map = (Map)modelList.get(i2);
            engine.modelGenerator(map);
        }
        List clientList = engine.getClientList(list);
        for (i = 0; i < clientList.size(); ++i) {
            map = (Map)clientList.get(i);
            engine.clientGenerator(map);
        }
        for (i = 0; i < clientList.size(); ++i) {
            map = (Map)clientList.get(i);
            engine.utilGenerator(map);
            engine.testGenerator(map);
        }
    }

    public void testGenerator(Map<String, String> map) {
        File file = new File(this.testTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.testTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            logger.error((Object)("\u751f\u6210\u6d4b\u8bd5\u5de5\u5177\u7c7b\u4ee3\u7801:" + map));
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String testFile = this.testDir + "/com/miniframe/comm/" + map.get("apater").toLowerCase() + "/" + map.get("\u4ea4\u6613\u7f16\u7801").toUpperCase() + "Test.java";
                File file1 = new File(testFile);
                if (!file1.exists()) {
                    MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.testTemplate), testFile);
                }
            }
            catch (Exception var6) {
                logger.error((Object)"\u751f\u6210model\u6587\u4ef6\u9519\u8bef:", (Throwable)var6);
            }
        }
    }

    public void utilGenerator(Map<String, String> map) {
        File file = new File(this.utilTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.utilTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            logger.error((Object)("\u751f\u6210\u9002\u914d\u5668\u5de5\u5177\u7c7b\u4ee3\u7801:" + map));
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String utilFile = this.testDir + "/com/miniframe/comm/" + map.get("apater").toLowerCase() + "/" + DesignerTools.capName(map.get("apater").toLowerCase()) + "Util.java";
                File file1 = new File(utilFile);
                if (!file1.exists()) {
                    MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.utilTemplate), utilFile);
                }
            }
            catch (Exception var6) {
                logger.error((Object)"\u751f\u6210model\u6587\u4ef6\u9519\u8bef:", (Throwable)var6);
            }
        }
    }

    public void clientGenerator(Map<String, String> map) {
        File file = new File(this.clientTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.clientTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            logger.error((Object)("\u751f\u6210\u5ba2\u6237\u7aef\u901a\u8baf\u6570\u636e:" + map));
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String clientFile = this.modelDir + "/com/miniframe/generate/comm/" + map.get("apater").toLowerCase() + "/" + map.get("\u4ea4\u6613\u7f16\u7801").toUpperCase() + "Client.java";
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.clientTemplate), clientFile);
            }
            catch (Exception var5) {
                logger.error((Object)"\u751f\u6210model\u6587\u4ef6\u9519\u8bef:", (Throwable)var5);
            }
        }
    }

    public void modelGenerator(Map<String, String> map) {
        File file = new File(this.modelTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.modelTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String modelFile = this.modelDir + "/com/miniframe/generate/business/" + map.get("code") + "/model/" + map.get("\u4ea4\u6613\u7f16\u7801").toUpperCase() + "BaseModel.java";
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.modelTemplate), modelFile);
            }
            catch (Exception var5) {
                logger.error((Object)"\u751f\u6210model\u6587\u4ef6\u9519\u8bef:", (Throwable)var5);
            }
        }
    }

    public void xmlGenerator(List<CommCodeInfo> list) {
        File file = new File(this.xmlTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.xmlTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            logger.error((Object)("--->" + list));
            for (int i = 0; i < list.size(); ++i) {
                VelocityContext ctx = new VelocityContext();
                ArrayList mapList = new ArrayList();
                Map<?, ?> map = JsonTransServiceEngine.obj2Map(list.get(i));
                mapList.add(map);
                ctx.put("list", mapList);
                String clientName = (String)map.get("code");
                try {
                    MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.xmlTemplate), this.xmlDir + "/applicationContext-comm-" + clientName + ".xml");
                    continue;
                }
                catch (Exception var9) {
                    logger.error((Object)"\u751f\u6210xml\u9519\u8bef:", (Throwable)var9);
                }
            }
        }
    }

    public void feignGenerator(List<CommCodeInfo> list) {
        File file = new File(this.feignTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.feignTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            String[] strings;
            logger.error((Object)("--->" + list));
            VelocityContext ctx = new VelocityContext();
            if (this.serviceName == null) {
                this.serviceName = "";
            }
            String oriFileName = this.serviceName.replaceAll("[^0-9a-zA-Z.]", "");
            String fileName = "";
            if (oriFileName.contains(".") && (strings = StringUtils.split((String)oriFileName, (String)".")) != null) {
                for (String s : strings) {
                    fileName = fileName + StringUtils.capitalize((String)s);
                }
            }
            if (fileName.isEmpty()) {
                fileName = StringUtils.capitalize((String)oriFileName);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("serviceName", this.serviceName);
            map.put("fileName", fileName);
            ctx.put("map", map);
            try {
                MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.feignTemplate), this.feignDir + "/com/miniframe/feign/IFeign" + fileName + ".java");
            }
            catch (Exception var9) {
                logger.error((Object)"\u751f\u6210xml\u9519\u8bef:", (Throwable)var9);
            }
        }
    }

    public List getModelList(List<CommCodeInfo> list) throws Exception {
        ArrayList transList = new ArrayList();
        HashMap<String, String> limitMap = new HashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            CommCodeInfo info = list.get(i);
            String transHead = (String)((Map)info.getMap().get("headname")).get("\u8bbe\u7f6e\u503c");
            String transDir = (String)((Map)info.getMap().get("transDir")).get("\u8bbe\u7f6e\u503c");
            CodeInfo sortInfo = JsonTransServiceEngine.getCodeInfo(transDir);
            String dirPath = this.dataDir;
            if (!dirPath.endsWith("/")) {
                dirPath = dirPath + "/";
            }
            dirPath = dirPath + "../\u901a\u8baf\u62a5\u6587/" + transDir + "/\u62a5\u6587\u4f53/";
            List<CodeInfo> list1 = MiniVelocityEngine.findDesigner(dirPath);
            for (int j = 0; j < list1.size(); ++j) {
                CodeInfo child = list1.get(j);
                String childCode = child.getCode();
                int m = childCode.indexOf("_");
                if (limitMap.get(childCode = childCode.substring(0, m).trim()) != null) continue;
                limitMap.put(childCode, "");
                HashMap<String, String> childMap = new HashMap<String, String>();
                childMap.put("\u4ea4\u6613\u7f16\u7801", childCode);
                childMap.put("\u4ea4\u6613\u540d\u79f0", child.getName());
                childMap.put("head", transHead);
                childMap.put("code", sortInfo.getCode().replace("_", "").toLowerCase().trim());
                childMap.put("name", sortInfo.getName());
                transList.add(childMap);
            }
        }
        return transList;
    }

    public List getClientList(List<CommCodeInfo> list) throws Exception {
        ArrayList transList = new ArrayList();
        HashMap<String, String> limitMap = new HashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            CommCodeInfo info = list.get(i);
            String transHead = (String)((Map)info.getMap().get("headname")).get("\u8bbe\u7f6e\u503c");
            String transDir = (String)((Map)info.getMap().get("transDir")).get("\u8bbe\u7f6e\u503c");
            CodeInfo sortInfo = JsonTransServiceEngine.getCodeInfo(transDir);
            String dirPath = this.dataDir;
            if (!dirPath.endsWith("/")) {
                dirPath = dirPath + "/";
            }
            dirPath = dirPath + "../\u901a\u8baf\u62a5\u6587/" + transDir + "/\u62a5\u6587\u4f53/";
            List<CodeInfo> list1 = MiniVelocityEngine.findDesigner(dirPath);
            for (int j = 0; j < list1.size(); ++j) {
                CodeInfo child = list1.get(j);
                String childCode = child.getCode();
                int m = childCode.indexOf("_");
                if (limitMap.get(childCode = childCode.substring(0, m).trim()) != null) continue;
                limitMap.put(childCode, "");
                HashMap<String, String> childMap = new HashMap<String, String>();
                childMap.put("\u4ea4\u6613\u7f16\u7801", childCode);
                childMap.put("\u4ea4\u6613\u540d\u79f0", child.getName());
                childMap.put("head", transHead);
                childMap.put("apater", info.getCode().trim());
                childMap.put("code", sortInfo.getCode().replace("_", "").toLowerCase().trim());
                childMap.put("name", sortInfo.getName());
                transList.add(childMap);
            }
        }
        return transList;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getXmlDir() {
        return this.xmlDir;
    }

    public void setXmlDir(String xmlDir) {
        this.xmlDir = xmlDir;
    }

    public String getXmlTemplate() {
        return this.xmlTemplate;
    }

    public void setXmlTemplate(String xmlTemplate) {
        this.xmlTemplate = xmlTemplate;
    }

    public String getModelDir() {
        return this.modelDir;
    }

    public void setModelDir(String modelDir) {
        this.modelDir = modelDir;
    }

    public String getModelTemplate() {
        return this.modelTemplate;
    }

    public void setModelTemplate(String modelTemplate) {
        this.modelTemplate = modelTemplate;
    }

    public String getClientTemplate() {
        return this.clientTemplate;
    }

    public void setClientTemplate(String clientTemplate) {
        this.clientTemplate = clientTemplate;
    }

    public String getTestDir() {
        return this.testDir;
    }

    public void setTestDir(String testDir) {
        this.testDir = testDir;
    }

    public String getUtilTemplate() {
        return this.utilTemplate;
    }

    public void setUtilTemplate(String utilTemplate) {
        this.utilTemplate = utilTemplate;
    }

    public String getTestTemplate() {
        return this.testTemplate;
    }

    public void setTestTemplate(String testTemplate) {
        this.testTemplate = testTemplate;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getFeignTemplate() {
        return this.feignTemplate;
    }

    public void setFeignTemplate(String feignTemplate) {
        this.feignTemplate = feignTemplate;
    }

    public String getFeignDir() {
        return this.feignDir;
    }

    public void setFeignDir(String feignDir) {
        this.feignDir = feignDir;
    }
}

