/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.csv.CsvReader;
import com.miniframe.designer.model.CodeInfo;
import com.miniframe.designer.model.CommCodeInfo;
import com.miniframe.designer.util.DesignerTools;
import com.miniframe.designer.util.ObjAnalysis;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class MiniVelocityEngine {
    public static Map<?, ?> obj2Map(Object obj) {
        ObjAnalysis objAnalysis = new ObjAnalysis(obj, obj.getClass());
        Map map = objAnalysis.getObjPropertyMap();
        return map;
    }

    public static List<Map<String, String>> getCsvList(String fileName) throws Exception {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        CsvReader r = new CsvReader(fileName, ',', Charset.forName("UTF-8"));
        ArrayList<String> headerList = new ArrayList<String>();
        if (r.readRecord()) {
            for (int i = 0; i < r.getColumnCount(); ++i) {
                headerList.add(r.get(i));
            }
        }
        while (r.readRecord()) {
            LinkedHashMap<String, String> csvmap = new LinkedHashMap<String, String>();
            for (int i = 0; i < headerList.size(); ++i) {
                String head = ((String)headerList.get(i)).trim();
                if (head.startsWith("\"")) {
                    head = head.substring(1);
                }
                if (head.endsWith("\"")) {
                    head = head.substring(0, head.length() - 1);
                }
                head = head.trim();
                csvmap.put(head, r.get(i));
            }
            list.add(csvmap);
        }
        r.close();
        return list;
    }

    public static Map getCommCsvList(String fileName) throws Exception {
        LinkedHashMap map = new LinkedHashMap();
        CsvReader r = new CsvReader(fileName, ',', Charset.forName("UTF-8"));
        ArrayList<String> headerList = new ArrayList<String>();
        if (r.readRecord()) {
            for (int i = 0; i < r.getColumnCount(); ++i) {
                headerList.add(r.get(i));
            }
        }
        while (r.readRecord()) {
            LinkedHashMap<String, String> csvmap = new LinkedHashMap<String, String>();
            for (int i = 0; i < headerList.size(); ++i) {
                String head = ((String)headerList.get(i)).trim();
                if (head.startsWith("\"")) {
                    head = head.substring(1);
                }
                if (head.endsWith("\"")) {
                    head = head.substring(0, head.length() - 1);
                }
                head = head.trim();
                csvmap.put(head, r.get(i));
            }
            map.put(csvmap.get("\u82f1\u6587\u540d\u79f0"), csvmap);
        }
        r.close();
        return map;
    }

    public static CodeInfo getCodeInfo(String fileName) {
        CodeInfo info = new CodeInfo();
        int i = fileName.indexOf("(");
        int j = fileName.indexOf(")");
        if (i > 0 && j > 0) {
            info.setCode(fileName.substring(0, i));
            info.setName(fileName.substring(i + 1, j));
        } else {
            int k = fileName.indexOf(".");
            info.setCode(fileName.substring(0, k));
            info.setName(fileName.substring(0, k));
        }
        return info;
    }

    public static CommCodeInfo getCommCodeInfo(String fileName) {
        CommCodeInfo info = new CommCodeInfo();
        int i = fileName.indexOf("(");
        int j = fileName.indexOf(").");
        if (i > 0 && j > 0) {
            info.setCode(fileName.substring(0, i));
            info.setName(fileName.substring(i + 1, j));
        } else {
            int k = fileName.indexOf(".");
            info.setCode(fileName.substring(0, k));
            info.setName(fileName.substring(0, k));
        }
        return info;
    }

    public static List<CodeInfo> findDesigner(String dirName) throws Exception {
        File file = new File(dirName);
        String[] files = file.list();
        ArrayList<CodeInfo> list = new ArrayList<CodeInfo>();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                CodeInfo info;
                if (!files[i].endsWith(".csv") || (info = MiniVelocityEngine.getCodeInfo(files[i])) == null) continue;
                info.setList(MiniVelocityEngine.getCsvList(dirName + "/" + files[i]));
                list.add(info);
            }
        }
        return list;
    }

    public static List<CommCodeInfo> findCommDesigner(String dirName) throws Exception {
        File file = new File(dirName);
        String[] files = file.list();
        ArrayList<CommCodeInfo> list = new ArrayList<CommCodeInfo>();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                CommCodeInfo info;
                if (!files[i].endsWith(".csv") || (info = MiniVelocityEngine.getCommCodeInfo(files[i])) == null) continue;
                info.setMap(MiniVelocityEngine.getCommCsvList(dirName + "/" + files[i]));
                list.add(info);
            }
        }
        return list;
    }

    public static String getSysProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            new Exception("SysProperty [" + key + "] not Setting.");
        }
        return value;
    }

    public static void delFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public static String getDir(String key) {
        String dirName = System.getProperty(key);
        if (!(dirName = dirName.replace("\\", "/")).endsWith("/")) {
            dirName = dirName + "/";
        }
        return dirName;
    }

    public static Map getRuleMap(String ruleDir) throws Exception {
        List<CodeInfo> ruleList = MiniVelocityEngine.findDesigner(ruleDir);
        HashMap globalRulMap = new HashMap();
        for (int i = 0; i < ruleList.size(); ++i) {
            Map<?, ?> tmp = MiniVelocityEngine.obj2Map(ruleList.get(i));
            List cList = (List)tmp.get("list");
            for (int j = 0; j < cList.size(); ++j) {
                Map map = (Map)cList.get(j);
                globalRulMap.put(map.get("\u82f1\u6587\u540d\u79f0"), cList.get(j));
            }
        }
        return globalRulMap;
    }

    public static Map getAppCodeMap(String appcodeDir) throws Exception {
        List<CodeInfo> appcodeList = MiniVelocityEngine.findDesigner(appcodeDir);
        HashMap<String, String> appcodeMap = new HashMap<String, String>();
        for (int i = 0; i < appcodeList.size(); ++i) {
            CodeInfo info = appcodeList.get(i);
            appcodeMap.put(info.getCode(), info.getName());
        }
        return appcodeMap;
    }

    public static String encode(VelocityContext ctx, String templateFile) {
        VelocityEngine ve = new VelocityEngine();
        Properties prop = new Properties();
        File file = new File(templateFile);
        prop.setProperty("file.resource.loader.path", file.getParent());
        ve.init(prop);
        Template template = ve.getTemplate(file.getName(), "UTF-8");
        StringWriter sw = new StringWriter();
        DesignerTools tools = new DesignerTools();
        ctx.put("tools", (Object)tools);
        String baseCode = MiniVelocityEngine.getSysProperty("baseCode");
        ctx.put("baseCode", (Object)baseCode);
        template.merge((Context)ctx, (Writer)sw);
        String returnString = sw.toString();
        return returnString;
    }

    public static void writefile(String buffer, String fileName) throws Exception {
        File file = new File(fileName);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (file.exists()) {
            file.delete();
        }
        try (FileOutputStream out = null;){
            out = new FileOutputStream(file);
            out.write(buffer.getBytes());
        }
    }
}

