/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.internal.util;

import java.util.Locale;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;

public class JavaBeansUtil {
    private JavaBeansUtil() {
    }

    public static String getGetterMethodName(String property, FullyQualifiedJavaType fullyQualifiedJavaType) {
        StringBuilder sb = new StringBuilder();
        sb.append(property);
        if (Character.isLowerCase(sb.charAt(0)) && (sb.length() == 1 || !Character.isUpperCase(sb.charAt(1)))) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        if (fullyQualifiedJavaType.equals(FullyQualifiedJavaType.getBooleanPrimitiveInstance())) {
            sb.insert(0, "is");
        } else {
            sb.insert(0, "get");
        }
        return sb.toString();
    }

    public static String getSetterMethodName(String property) {
        StringBuilder sb = new StringBuilder();
        sb.append(property);
        if (Character.isLowerCase(sb.charAt(0)) && (sb.length() == 1 || !Character.isUpperCase(sb.charAt(1)))) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        sb.insert(0, "set");
        return sb.toString();
    }

    public static String getCamelCaseString(String inputString, boolean firstCharacterUppercase) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        int i = 0;
        while (i < inputString.length()) {
            char c = inputString.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '&': 
                case '-': 
                case '/': 
                case '@': 
                case '_': {
                    if (sb.length() <= 0) break;
                    nextUpperCase = true;
                    break;
                }
                default: {
                    if (nextUpperCase) {
                        sb.append(Character.toUpperCase(c));
                        nextUpperCase = false;
                        break;
                    }
                    sb.append(Character.toLowerCase(c));
                }
            }
            ++i;
        }
        if (firstCharacterUppercase) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static String getValidPropertyName(String inputString) {
        String answer = inputString == null ? null : (inputString.length() < 2 ? inputString.toLowerCase(Locale.US) : (Character.isUpperCase(inputString.charAt(0)) && !Character.isUpperCase(inputString.charAt(1)) ? String.valueOf(inputString.substring(0, 1).toLowerCase(Locale.US)) + inputString.substring(1) : inputString));
        return answer;
    }
}

