/*
 * Decompiled with CFR 0.152.
 */
package tk.mybatis.spring.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import tk.mybatis.spring.annotation.MapperScan;
import tk.mybatis.spring.mapper.ClassPathMapperScanner;
import tk.mybatis.spring.mapper.MapperFactoryBean;

public class MapperScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    public static final Logger LOGGER = LoggerFactory.getLogger(MapperScannerRegistrar.class);
    private ResourceLoader resourceLoader;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Class mapperFactoryBeanClass;
        Class generatorClass;
        Class markerInterface;
        Class annotationClass;
        AnnotationAttributes annoAttrs = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(MapperScan.class.getName()));
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
        if (this.resourceLoader != null) {
            scanner.setResourceLoader(this.resourceLoader);
        }
        if (!Annotation.class.equals((Object)(annotationClass = annoAttrs.getClass("annotationClass")))) {
            scanner.setAnnotationClass(annotationClass);
        }
        if (!Class.class.equals((Object)(markerInterface = annoAttrs.getClass("markerInterface")))) {
            scanner.setMarkerInterface(markerInterface);
        }
        if (!BeanNameGenerator.class.equals((Object)(generatorClass = annoAttrs.getClass("nameGenerator")))) {
            scanner.setBeanNameGenerator((BeanNameGenerator)BeanUtils.instantiateClass((Class)generatorClass));
        }
        if (!MapperFactoryBean.class.equals((Object)(mapperFactoryBeanClass = annoAttrs.getClass("factoryBean")))) {
            scanner.setMapperFactoryBean((MapperFactoryBean)((Object)BeanUtils.instantiateClass((Class)mapperFactoryBeanClass)));
        }
        scanner.setSqlSessionTemplateBeanName(annoAttrs.getString("sqlSessionTemplateRef"));
        scanner.setSqlSessionFactoryBeanName(annoAttrs.getString("sqlSessionFactoryRef"));
        ArrayList<String> basePackages = new ArrayList<String>();
        for (String pkg : annoAttrs.getStringArray("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : annoAttrs.getStringArray("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : annoAttrs.getClassArray("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        String mapperHelperRef = annoAttrs.getString("mapperHelperRef");
        String[] properties = annoAttrs.getStringArray("properties");
        if (StringUtils.hasText((String)mapperHelperRef)) {
            scanner.setMapperHelperBeanName(mapperHelperRef);
        } else if (properties != null && properties.length > 0) {
            scanner.setMapperProperties(properties);
        } else {
            try {
                scanner.setMapperProperties(this.environment);
            }
            catch (Exception e) {
                LOGGER.warn("\u53ea\u6709 Spring Boot \u73af\u5883\u4e2d\u53ef\u4ee5\u901a\u8fc7 Environment(\u914d\u7f6e\u6587\u4ef6,\u73af\u5883\u53d8\u91cf,\u8fd0\u884c\u53c2\u6570\u7b49\u65b9\u5f0f) \u914d\u7f6e\u901a\u7528 Mapper\uff0c\u5176\u4ed6\u73af\u5883\u8bf7\u901a\u8fc7 @MapperScan \u6ce8\u89e3\u4e2d\u7684 mapperHelperRef \u6216 properties \u53c2\u6570\u8fdb\u884c\u914d\u7f6e!\u5982\u679c\u4f60\u4f7f\u7528 tk.mybatis.mapper.session.Configuration \u914d\u7f6e\u7684\u901a\u7528 Mapper\uff0c\u4f60\u53ef\u4ee5\u5ffd\u7565\u8be5\u9519\u8bef!", (Throwable)e);
            }
        }
        scanner.registerFilters();
        scanner.doScan(StringUtils.toStringArray(basePackages));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

