/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.plugins;

import java.util.List;
import org.apache.ibatis.ibator.api.IbatorPluginAdapter;
import org.apache.ibatis.ibator.api.IntrospectedTable;
import org.apache.ibatis.ibator.api.dom.java.Field;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.java.JavaVisibility;
import org.apache.ibatis.ibator.api.dom.java.Method;
import org.apache.ibatis.ibator.api.dom.java.Parameter;
import org.apache.ibatis.ibator.api.dom.java.TopLevelClass;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.Document;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.generator.ibatis2.sqlmap.elements.AbstractXmlElementGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.sqlmap.elements.OraclePaginationHeadGenerator;
import org.apache.ibatis.ibator.generator.ibatis2.sqlmap.elements.OraclePaginationTailGenerator;
import org.apache.ibatis.ibator.internal.util.StringUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaginationPlugin
extends IbatorPluginAdapter {
    private String enablePagination;
    private String databaseType;

    @Override
    public boolean validate(List<String> warnings) {
        this.databaseType = this.properties.getProperty("databaseType");
        this.enablePagination = this.properties.getProperty("enablePagination");
        boolean valid = StringUtility.stringHasValue(this.databaseType) && StringUtility.stringHasValue(this.enablePagination);
        return valid;
    }

    @Override
    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        XmlElement element = document.getRootElement();
        if (StringUtility.stringHasValue(this.enablePagination) && "true".equalsIgnoreCase(this.enablePagination)) {
            OraclePaginationTailGenerator oraclePaginationTailGenerator = new OraclePaginationTailGenerator();
            oraclePaginationTailGenerator.setIbatorContext(this.ibatorContext);
            oraclePaginationTailGenerator.setIntrospectedTable(introspectedTable);
            ((AbstractXmlElementGenerator)oraclePaginationTailGenerator).addElements(element);
            OraclePaginationHeadGenerator oraclePaginationHeadGenerator = new OraclePaginationHeadGenerator();
            oraclePaginationHeadGenerator.setIbatorContext(this.ibatorContext);
            oraclePaginationHeadGenerator.setIntrospectedTable(introspectedTable);
            ((AbstractXmlElementGenerator)oraclePaginationHeadGenerator).addElements(element);
        }
        return super.sqlMapDocumentGenerated(document, introspectedTable);
    }

    @Override
    public boolean sqlMapSelectByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (StringUtility.stringHasValue(this.enablePagination) && "true".equalsIgnoreCase(this.enablePagination)) {
            XmlElement oracleHeadIncludeElement = new XmlElement("include");
            oracleHeadIncludeElement.addAttribute(new Attribute("refid", String.valueOf(introspectedTable.getIbatis2SqlMapNamespace()) + "." + "oracle_Pagination_Head"));
            element.addElement(0, oracleHeadIncludeElement);
            XmlElement oracleTailIncludeElement = new XmlElement("include");
            oracleTailIncludeElement.addAttribute(new Attribute("refid", String.valueOf(introspectedTable.getIbatis2SqlMapNamespace()) + "." + "oracle_Pagination_Tail"));
            element.addElement(element.getElements().size(), oracleTailIncludeElement);
        }
        return super.sqlMapExampleWhereClauseElementGenerated(element, introspectedTable);
    }

    @Override
    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (StringUtility.stringHasValue(this.enablePagination) && "true".equalsIgnoreCase(this.enablePagination)) {
            XmlElement oracleHeadIncludeElement = new XmlElement("include");
            oracleHeadIncludeElement.addAttribute(new Attribute("refid", String.valueOf(introspectedTable.getIbatis2SqlMapNamespace()) + "." + "oracle_Pagination_Head"));
            element.addElement(0, oracleHeadIncludeElement);
            XmlElement oracleTailIncludeElement = new XmlElement("include");
            oracleTailIncludeElement.addAttribute(new Attribute("refid", String.valueOf(introspectedTable.getIbatis2SqlMapNamespace()) + "." + "oracle_Pagination_Tail"));
            element.addElement(element.getElements().size(), oracleTailIncludeElement);
        }
        return super.sqlMapSelectByExampleWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    @Override
    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.ibatorContext.getCommentGenerator().addClassComment(topLevelClass, introspectedTable);
        if (StringUtility.stringHasValue(this.enablePagination) && "true".equalsIgnoreCase(this.enablePagination)) {
            Field field = new Field();
            field.setVisibility(JavaVisibility.PRIVATE);
            field.setType(FullyQualifiedJavaType.getInteger());
            field.setName("oracleStart");
            topLevelClass.addField(field);
            this.ibatorContext.getCommentGenerator().addFieldComment(field, introspectedTable);
            Method method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setName("setOracleStart");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getInteger(), "oracleStart"));
            method.addBodyLine("this.oracleStart = oracleStart;");
            method.addBodyLine("this.startOffSet = this.oracleStart - 1;");
            method.addBodyLine("if(this.oracleEnd!=null){");
            method.addBodyLine("this.pageSize = this.oracleEnd - this.oracleStart + 1;");
            method.addBodyLine("}");
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u8bbe\u7f6e\u5f00\u59cb\u884c\uff0c\u4ece1\u5f00\u59cb");
            topLevelClass.addMethod(method);
            method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setReturnType(FullyQualifiedJavaType.getInteger());
            method.setName("getOracleStart");
            method.addBodyLine("return oracleStart;");
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u83b7\u53d6\u5f00\u59cb\u884c\uff0c\u4ece1\u5f00\u59cb");
            topLevelClass.addMethod(method);
            field = new Field();
            field.setVisibility(JavaVisibility.PRIVATE);
            field.setType(FullyQualifiedJavaType.getInteger());
            field.setName("oracleEnd");
            this.ibatorContext.getCommentGenerator().addFieldComment(field, introspectedTable);
            topLevelClass.addField(field);
            method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setName("setOracleEnd");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getInteger(), "oracleEnd"));
            method.addBodyLine("if(this.oracleStart==null){");
            method.addBodyLine("\tthis.oracleStart =1;");
            method.addBodyLine("\tthis.startOffSet =0;");
            method.addBodyLine("}");
            method.addBodyLine("this.oracleEnd = oracleEnd;");
            method.addBodyLine("this.pageSize = this.oracleEnd - this.oracleStart + 1;");
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u8bbe\u7f6e\u7ed3\u675f\u884c");
            topLevelClass.addMethod(method);
            method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setReturnType(FullyQualifiedJavaType.getInteger());
            method.setName("getOracleEnd");
            method.addBodyLine("return oracleEnd;");
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u83b7\u53d6\u7ed3\u675f\u884c");
            topLevelClass.addMethod(method);
            field = new Field();
            field.setVisibility(JavaVisibility.PRIVATE);
            field.setType(FullyQualifiedJavaType.getInteger());
            field.setName("startOffSet");
            this.ibatorContext.getCommentGenerator().addFieldComment(field, introspectedTable);
            topLevelClass.addField(field);
            method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setName("setStartOffSet");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getInteger(), "startOffSet"));
            method.addBodyLine("this.startOffSet = startOffSet;");
            method.addBodyLine("this.oracleStart = this.startOffSet + 1;");
            method.addBodyLine("if(this.pageSize!=null){");
            method.addBodyLine(" this.oracleEnd = this.oracleStart - 1 + this.pageSize;");
            method.addBodyLine("}");
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u8bbe\u7f6e\u504f\u79fb\u91cf\uff0c\u4ece0\u5f00\u59cb");
            topLevelClass.addMethod(method);
            method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setReturnType(FullyQualifiedJavaType.getInteger());
            method.setName("getStartOffSet");
            method.addBodyLine("return startOffSet;");
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u83b7\u53d6\u504f\u79fb\u91cf\uff0c\u4ece0\u5f00\u59cb");
            topLevelClass.addMethod(method);
            field = new Field();
            field.setVisibility(JavaVisibility.PRIVATE);
            field.setType(FullyQualifiedJavaType.getInteger());
            field.setName("pageSize");
            this.ibatorContext.getCommentGenerator().addFieldComment(field, introspectedTable);
            topLevelClass.addField(field);
            method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setName("setPageSize");
            method.addParameter(new Parameter(FullyQualifiedJavaType.getInteger(), "pageSize"));
            method.addBodyLine("if(this.oracleStart==null){");
            method.addBodyLine("\tthis.oracleStart =1;");
            method.addBodyLine("\tthis.startOffSet =0;");
            method.addBodyLine("}");
            method.addBodyLine("this.pageSize = pageSize;");
            method.addBodyLine("this.oracleEnd = this.pageSize + this.oracleStart - 1;");
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u8bbe\u7f6e\u9875\u5c3a\u5bf8");
            topLevelClass.addMethod(method);
            method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setReturnType(FullyQualifiedJavaType.getInteger());
            method.setName("getPageSize");
            method.addBodyLine("return pageSize;");
            this.ibatorContext.getCommentGenerator().addGeneralMethodComment(method, "\u83b7\u53d6\u9875\u5c3a\u5bf8");
            topLevelClass.addMethod(method);
        }
        return super.modelExampleClassGenerated(topLevelClass, introspectedTable);
    }
}

