/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import org.apache.ibatis.ibator.exception.ShellException;
import org.apache.ibatis.ibator.internal.util.messages.Messages;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DomWriter {
    protected PrintWriter printWriter;
    protected boolean isXML11;

    public synchronized String toString(Document document) throws ShellException {
        StringWriter sw = new StringWriter();
        this.printWriter = new PrintWriter(sw);
        this.write(document);
        String s = sw.toString();
        return s;
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        i = 0;
        while (i < len - 1) {
            String name = array[i].getNodeName();
            int index = i;
            int j = i + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i) {
                Attr temp = array[i];
                array[i] = array[index];
                array[index] = temp;
            }
            ++i;
        }
        return array;
    }

    protected void normalizeAndPrint(String s, boolean isAttValue) {
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            this.normalizeAndPrint(c, isAttValue);
            ++i;
        }
    }

    protected void normalizeAndPrint(char c, boolean isAttValue) {
        switch (c) {
            case '<': {
                this.printWriter.print("&lt;");
                break;
            }
            case '>': {
                this.printWriter.print("&gt;");
                break;
            }
            case '&': {
                this.printWriter.print("&amp;");
                break;
            }
            case '\"': {
                if (isAttValue) {
                    this.printWriter.print("&quot;");
                    break;
                }
                this.printWriter.print('\"');
                break;
            }
            case '\r': {
                this.printWriter.print("&#xD;");
                break;
            }
            default: {
                if (this.isXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || isAttValue && (c == '\t' || c == '\n')) {
                    this.printWriter.print("&#x");
                    this.printWriter.print(Integer.toHexString(c).toUpperCase());
                    this.printWriter.print(';');
                    break;
                }
                this.printWriter.print(c);
            }
        }
    }

    protected String getVersion(Document document) {
        if (document == null) {
            return null;
        }
        String version = null;
        Method getXMLVersion = null;
        try {
            getXMLVersion = document.getClass().getMethod("getXmlVersion", new Class[0]);
            if (getXMLVersion != null) {
                version = (String)getXMLVersion.invoke((Object)document, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    protected void writeAnyNode(Node node) throws ShellException {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                this.write((Document)node);
                break;
            }
            case 10: {
                this.write((DocumentType)node);
                break;
            }
            case 1: {
                this.write((Element)node);
                break;
            }
            case 5: {
                this.write((EntityReference)node);
                break;
            }
            case 4: {
                this.write((CDATASection)node);
                break;
            }
            case 3: {
                this.write((Text)node);
                break;
            }
            case 7: {
                this.write((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.write((Comment)node);
                break;
            }
            default: {
                throw new ShellException(Messages.getString("RuntimeError.18", Short.toString(type)));
            }
        }
    }

    protected void write(Document node) throws ShellException {
        this.isXML11 = "1.1".equals(this.getVersion(node));
        if (this.isXML11) {
            this.printWriter.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
        } else {
            this.printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        this.printWriter.flush();
        this.write(node.getDoctype());
        this.write(node.getDocumentElement());
    }

    protected void write(DocumentType node) throws ShellException {
        this.printWriter.print("<!DOCTYPE ");
        this.printWriter.print(node.getName());
        String publicId = node.getPublicId();
        String systemId = node.getSystemId();
        if (publicId != null) {
            this.printWriter.print(" PUBLIC \"");
            this.printWriter.print(publicId);
            this.printWriter.print("\" \"");
            this.printWriter.print(systemId);
            this.printWriter.print('\"');
        } else if (systemId != null) {
            this.printWriter.print(" SYSTEM \"");
            this.printWriter.print(systemId);
            this.printWriter.print('\"');
        }
        String internalSubset = node.getInternalSubset();
        if (internalSubset != null) {
            this.printWriter.println(" [");
            this.printWriter.print(internalSubset);
            this.printWriter.print(']');
        }
        this.printWriter.println('>');
    }

    protected void write(Element node) throws ShellException {
        Attr[] attrs;
        this.printWriter.print('<');
        this.printWriter.print(node.getNodeName());
        Attr[] attrArray = attrs = this.sortAttributes(node.getAttributes());
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Attr attr = attrArray[n2];
            this.printWriter.print(' ');
            this.printWriter.print(attr.getNodeName());
            this.printWriter.print("=\"");
            this.normalizeAndPrint(attr.getNodeValue(), true);
            this.printWriter.print('\"');
            ++n2;
        }
        if (node.getChildNodes().getLength() == 0) {
            this.printWriter.print(" />");
            this.printWriter.flush();
        } else {
            this.printWriter.print('>');
            this.printWriter.flush();
            Node child = node.getFirstChild();
            while (child != null) {
                this.writeAnyNode(child);
                child = child.getNextSibling();
            }
            this.printWriter.print("</");
            this.printWriter.print(node.getNodeName());
            this.printWriter.print('>');
            this.printWriter.flush();
        }
    }

    protected void write(EntityReference node) {
        this.printWriter.print('&');
        this.printWriter.print(node.getNodeName());
        this.printWriter.print(';');
        this.printWriter.flush();
    }

    protected void write(CDATASection node) {
        this.printWriter.print("<![CDATA[");
        this.printWriter.print(node.getNodeValue());
        this.printWriter.print("]]>");
        this.printWriter.flush();
    }

    protected void write(Text node) {
        this.normalizeAndPrint(node.getNodeValue(), false);
        this.printWriter.flush();
    }

    protected void write(ProcessingInstruction node) {
        this.printWriter.print("<?");
        this.printWriter.print(node.getNodeName());
        String data = node.getNodeValue();
        if (data != null && data.length() > 0) {
            this.printWriter.print(' ');
            this.printWriter.print(data);
        }
        this.printWriter.print("?>");
        this.printWriter.flush();
    }

    protected void write(Comment node) {
        this.printWriter.print("<!--");
        String comment = node.getNodeValue();
        if (comment != null && comment.length() > 0) {
            this.printWriter.print(comment);
        }
        this.printWriter.print("-->");
        this.printWriter.flush();
    }
}

