/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.logging;

import org.apache.ibatis.ibator.internal.IbatorObjectFactory;
import org.apache.ibatis.ibator.internal.util.messages.Messages;
import org.apache.ibatis.ibator.logging.AbstractLogFactory;
import org.apache.ibatis.ibator.logging.JdkLoggingImpl;
import org.apache.ibatis.ibator.logging.Log;
import org.apache.ibatis.ibator.logging.Log4jImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogFactory {
    private static AbstractLogFactory logFactory;

    static {
        try {
            IbatorObjectFactory.internalClassForName("org.apache.log4j.Logger");
            logFactory = new Log4jLoggingLogFactory();
        }
        catch (Exception e) {
            logFactory = new JdkLoggingLogFactory();
        }
    }

    public static Log getLog(Class<?> clazz) {
        try {
            return logFactory.getLog(clazz);
        }
        catch (Throwable t) {
            throw new RuntimeException(Messages.getString("RuntimeError.21", clazz.getName(), t.getMessage()), t);
        }
    }

    public static synchronized void forceJavaLogging() {
        logFactory = new JdkLoggingLogFactory();
    }

    public static void setLogFactory(AbstractLogFactory logFactory) {
        LogFactory.logFactory = logFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JdkLoggingLogFactory
    implements AbstractLogFactory {
        private JdkLoggingLogFactory() {
        }

        @Override
        public Log getLog(Class<?> clazz) {
            return new JdkLoggingImpl(clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Log4jLoggingLogFactory
    implements AbstractLogFactory {
        private Log4jLoggingLogFactory() {
        }

        @Override
        public Log getLog(Class<?> clazz) {
            return new Log4jImpl(clazz);
        }
    }
}

