/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.handler;

import com.taobao.api.internal.toplink.embedded.websocket.WebSocket;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.frame.Frame;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandler;
import java.nio.ByteBuffer;

public class StreamHandlerChain {
    private StreamHandlerChain next;
    private StreamHandlerChain prev;
    private final StreamHandler streamHandler;

    public StreamHandlerChain(StreamHandler streamHandler) {
        this.streamHandler = streamHandler;
    }

    public void nextHandshakeUpstreamHandler(WebSocket ws, ByteBuffer buffer) throws WebSocketException {
        if (this.prev != null) {
            this.prev.streamHandler.nextHandshakeUpstreamHandler(ws, buffer, this.prev);
        }
    }

    public void nextHandshakeDownstreamHandler(WebSocket ws, ByteBuffer buffer) throws WebSocketException {
        if (this.next != null) {
            this.next.streamHandler.nextHandshakeDownstreamHandler(ws, buffer, this.next);
        }
    }

    public void nextUpstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame) throws WebSocketException {
        if (this.prev != null) {
            this.prev.streamHandler.nextUpstreamHandler(ws, buffer, frame, this.prev);
        }
    }

    public void nextDownstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame) throws WebSocketException {
        if (this.next != null) {
            this.next.streamHandler.nextDownstreamHandler(ws, buffer, frame, this.next);
        }
    }

    public void add(StreamHandlerChain next) {
        this.next = next;
        next.prev = this;
    }

    public void clear() {
        this.next.clear();
        this.prev = null;
    }
}

