/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.generator.ibatis2.sqlmap.elements;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.ibatis.ibator.api.IntrospectedColumn;
import org.apache.ibatis.ibator.api.dom.OutputUtilities;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.TextElement;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.config.GeneratedKey;
import org.apache.ibatis.ibator.config.JDBCConnectionConfiguration;
import org.apache.ibatis.ibator.generator.ibatis2.Ibatis2FormattingUtilities;
import org.apache.ibatis.ibator.generator.ibatis2.sqlmap.elements.AbstractXmlElementGenerator;

public class InsertElementGenerator
extends AbstractXmlElementGenerator {
    public void addElements(XmlElement parentElement) {
        if (JDBCConnectionConfiguration.dbType.toLowerCase().indexOf(".db2") > 0) {
            IntrospectedColumn introspectedColumn3;
            IntrospectedColumn introspectedColumn2;
            XmlElement answer = new XmlElement("insert");
            answer.addAttribute(new Attribute("id", String.valueOf(this.introspectedTable.getIbatis2SqlMapNamespace()) + "." + this.introspectedTable.getInsertStatementId()));
            FullyQualifiedJavaType parameterType = this.introspectedTable.getRules().calculateAllFieldsClass();
            answer.addAttribute(new Attribute("parameterClass", parameterType.getFullyQualifiedName()));
            this.ibatorContext.getCommentGenerator().addComment(answer);
            GeneratedKey gk = this.introspectedTable.getGeneratedKey();
            if (gk != null && gk.isBeforeInsert() && (introspectedColumn2 = this.introspectedTable.getColumn(gk.getColumn())) != null) {
                answer.addElement(this.getSelectKey(introspectedColumn2, gk));
            }
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ");
            sb.append(this.introspectedTable.getFullyQualifiedTableNameAtRuntime());
            answer.addElement(new TextElement(sb.toString()));
            XmlElement insertElement = new XmlElement("dynamic");
            insertElement.addAttribute(new Attribute("prepend", "("));
            answer.addElement(insertElement);
            answer.addElement(new TextElement("values"));
            XmlElement valuesElement = new XmlElement("dynamic");
            valuesElement.addAttribute(new Attribute("prepend", "("));
            answer.addElement(valuesElement);
            for (IntrospectedColumn introspectedColumn3 : this.introspectedTable.getAllColumns()) {
                if (introspectedColumn3.isIdentity()) continue;
                XmlElement insertNotNullElement = new XmlElement("isNotNull");
                insertNotNullElement.addAttribute(new Attribute("prepend", ","));
                insertNotNullElement.addAttribute(new Attribute("property", introspectedColumn3.getJavaProperty()));
                insertNotNullElement.addElement(new TextElement(Ibatis2FormattingUtilities.getEscapedColumnName(introspectedColumn3)));
                insertElement.addElement(insertNotNullElement);
                XmlElement valuesNotNullElement = new XmlElement("isNotNull");
                valuesNotNullElement.addAttribute(new Attribute("prepend", ","));
                valuesNotNullElement.addAttribute(new Attribute("property", introspectedColumn3.getJavaProperty()));
                valuesNotNullElement.addElement(new TextElement(Ibatis2FormattingUtilities.getParameterClause(introspectedColumn3)));
                valuesElement.addElement(valuesNotNullElement);
            }
            insertElement.addElement(new TextElement(")"));
            valuesElement.addElement(new TextElement(")"));
            if (gk != null && !gk.isBeforeInsert() && (introspectedColumn3 = this.introspectedTable.getColumn(gk.getColumn())) != null) {
                answer.addElement(this.getSelectKey(introspectedColumn3, gk));
            }
            if (this.ibatorContext.getPlugins().sqlMapInsertSelectiveElementGenerated(answer, this.introspectedTable)) {
                parentElement.addElement(answer);
            }
        } else {
            IntrospectedColumn introspectedColumn;
            IntrospectedColumn introspectedColumn4;
            XmlElement answer = new XmlElement("insert");
            answer.addAttribute(new Attribute("id", String.valueOf(this.introspectedTable.getIbatis2SqlMapNamespace()) + "." + this.introspectedTable.getInsertStatementId()));
            FullyQualifiedJavaType parameterType = this.introspectedTable.getRules().calculateAllFieldsClass();
            answer.addAttribute(new Attribute("parameterClass", parameterType.getFullyQualifiedName()));
            this.ibatorContext.getCommentGenerator().addComment(answer);
            GeneratedKey gk = this.introspectedTable.getGeneratedKey();
            if (gk != null && gk.isBeforeInsert() && (introspectedColumn4 = this.introspectedTable.getColumn(gk.getColumn())) != null) {
                answer.addElement(this.getSelectKey(introspectedColumn4, gk));
            }
            StringBuilder insertClause = new StringBuilder();
            StringBuilder valuesClause = new StringBuilder();
            insertClause.append("insert into ");
            insertClause.append(this.introspectedTable.getFullyQualifiedTableNameAtRuntime());
            insertClause.append(" (");
            valuesClause.append("values (");
            ArrayList<String> valuesClauses = new ArrayList<String>();
            Iterator<IntrospectedColumn> iter = this.introspectedTable.getAllColumns().iterator();
            while (iter.hasNext()) {
                introspectedColumn = iter.next();
                if (introspectedColumn.isIdentity()) continue;
                insertClause.append(Ibatis2FormattingUtilities.getEscapedColumnName(introspectedColumn));
                valuesClause.append(Ibatis2FormattingUtilities.getParameterClause(introspectedColumn));
                if (iter.hasNext()) {
                    insertClause.append(", ");
                    valuesClause.append(", ");
                }
                if (valuesClause.length() <= 80) continue;
                answer.addElement(new TextElement(insertClause.toString()));
                insertClause.setLength(0);
                OutputUtilities.xmlIndent(insertClause, 1);
                valuesClauses.add(valuesClause.toString());
                valuesClause.setLength(0);
                OutputUtilities.xmlIndent(valuesClause, 1);
            }
            insertClause.append(')');
            answer.addElement(new TextElement(insertClause.toString()));
            valuesClause.append(')');
            valuesClauses.add(valuesClause.toString());
            for (String clause : valuesClauses) {
                answer.addElement(new TextElement(clause));
            }
            if (gk != null && !gk.isBeforeInsert() && (introspectedColumn = this.introspectedTable.getColumn(gk.getColumn())) != null) {
                answer.addElement(this.getSelectKey(introspectedColumn, gk));
            }
            if (this.ibatorContext.getPlugins().sqlMapInsertElementGenerated(answer, this.introspectedTable)) {
                parentElement.addElement(answer);
            }
        }
    }
}

