/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.type.VersionType;

public abstract class ReplicationMode
implements Serializable {
    private final int code;
    private final String name;
    private static final Map INSTANCES = new HashMap();
    public static final ReplicationMode EXCEPTION = new ReplicationMode(0, "EXCEPTION"){

        public boolean shouldOverwriteCurrentVersion(Object entity, Object currentVersion, Object newVersion, VersionType versionType) {
            throw new AssertionFailure("should not be called");
        }
    };
    public static final ReplicationMode IGNORE = new ReplicationMode(1, "IGNORE"){

        public boolean shouldOverwriteCurrentVersion(Object entity, Object currentVersion, Object newVersion, VersionType versionType) {
            return false;
        }
    };
    public static final ReplicationMode OVERWRITE = new ReplicationMode(3, "OVERWRITE"){

        public boolean shouldOverwriteCurrentVersion(Object entity, Object currentVersion, Object newVersion, VersionType versionType) {
            return true;
        }
    };
    public static final ReplicationMode LATEST_VERSION = new ReplicationMode(2, "LATEST_VERSION"){

        public boolean shouldOverwriteCurrentVersion(Object entity, Object currentVersion, Object newVersion, VersionType versionType) {
            if (versionType == null) {
                return true;
            }
            return versionType.getComparator().compare(currentVersion, newVersion) <= 0;
        }
    };

    public ReplicationMode(int level, String name) {
        this.code = level;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public abstract boolean shouldOverwriteCurrentVersion(Object var1, Object var2, Object var3, VersionType var4);

    private Object readResolve() {
        return INSTANCES.get(new Integer(this.code));
    }

    static {
        INSTANCES.put(new Integer(ReplicationMode.LATEST_VERSION.code), LATEST_VERSION);
        INSTANCES.put(new Integer(ReplicationMode.IGNORE.code), IGNORE);
        INSTANCES.put(new Integer(ReplicationMode.OVERWRITE.code), OVERWRITE);
        INSTANCES.put(new Integer(ReplicationMode.EXCEPTION.code), EXCEPTION);
    }
}

