/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AbstractCriterion;
import net.sf.hibernate.util.StringHelper;

public abstract class PropertyExpression
extends AbstractCriterion {
    private final String propertyName;
    private final String otherPropertyName;
    private static final TypedValue[] NO_TYPED_VALUES = new TypedValue[0];

    PropertyExpression(String propertyName, String otherPropertyName) {
        this.propertyName = propertyName;
        this.otherPropertyName = otherPropertyName;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias, Map aliasClasses) throws HibernateException {
        String[] xcols = PropertyExpression.getColumns(sessionFactory, persistentClass, this.propertyName, alias, aliasClasses);
        String[] ycols = PropertyExpression.getColumns(sessionFactory, persistentClass, this.otherPropertyName, alias, aliasClasses);
        String result = StringHelper.join(" and ", StringHelper.add(xcols, this.getOp(), ycols));
        if (xcols.length > 1) {
            result = "(" + result + ")";
        }
        return result;
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass, Map aliasClasses) throws HibernateException {
        return NO_TYPED_VALUES;
    }

    public String toString() {
        return this.propertyName + this.getOp() + this.otherPropertyName;
    }

    abstract String getOp();
}

