/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.config.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ibatis.ibator.config.ColumnOverride;
import org.apache.ibatis.ibator.config.ColumnRenamingRule;
import org.apache.ibatis.ibator.config.CommentGeneratorConfiguration;
import org.apache.ibatis.ibator.config.DAOGeneratorConfiguration;
import org.apache.ibatis.ibator.config.GeneratedKey;
import org.apache.ibatis.ibator.config.IbatorConfiguration;
import org.apache.ibatis.ibator.config.IbatorContext;
import org.apache.ibatis.ibator.config.IbatorPluginConfiguration;
import org.apache.ibatis.ibator.config.IgnoredColumn;
import org.apache.ibatis.ibator.config.JDBCConnectionConfiguration;
import org.apache.ibatis.ibator.config.JavaModelGeneratorConfiguration;
import org.apache.ibatis.ibator.config.JavaTypeResolverConfiguration;
import org.apache.ibatis.ibator.config.ModelType;
import org.apache.ibatis.ibator.config.PropertyHolder;
import org.apache.ibatis.ibator.config.SqlMapGeneratorConfiguration;
import org.apache.ibatis.ibator.config.TableConfiguration;
import org.apache.ibatis.ibator.config.xml.ParserEntityResolver;
import org.apache.ibatis.ibator.config.xml.ParserErrorHandler;
import org.apache.ibatis.ibator.exception.XMLParserException;
import org.apache.ibatis.ibator.internal.util.StringUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IbatorConfigurationParser {
    private List<String> warnings;
    private List<String> parseErrors;
    private Properties properties;

    public IbatorConfigurationParser(List<String> warnings) {
        this(null, warnings);
    }

    public IbatorConfigurationParser(Properties properties, List<String> warnings) {
        this.properties = properties == null ? System.getProperties() : properties;
        this.warnings = warnings == null ? new ArrayList<String>() : warnings;
        this.parseErrors = new ArrayList<String>();
    }

    public IbatorConfiguration parseIbatorConfiguration(File inputFile) throws IOException, XMLParserException {
        FileReader fr = new FileReader(inputFile);
        return this.parseIbatorConfiguration(fr);
    }

    public IbatorConfiguration parseIbatorConfiguration(Reader reader) throws IOException, XMLParserException {
        InputSource is = new InputSource(reader);
        return this.parseIbatorConfiguration(is);
    }

    public IbatorConfiguration parseIbatorConfiguration(InputStream inputStream) throws IOException, XMLParserException {
        InputSource is = new InputSource(inputStream);
        return this.parseIbatorConfiguration(is);
    }

    private IbatorConfiguration parseIbatorConfiguration(InputSource inputSource) throws IOException, XMLParserException {
        this.parseErrors.clear();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ParserEntityResolver());
            ParserErrorHandler handler = new ParserErrorHandler(this.warnings, this.parseErrors);
            builder.setErrorHandler(handler);
            Document document = null;
            try {
                document = builder.parse(inputSource);
            }
            catch (SAXParseException e) {
                e.printStackTrace();
                throw new XMLParserException(this.parseErrors);
            }
            catch (SAXException e) {
                if (e.getException() == null) {
                    this.parseErrors.add(e.getMessage());
                }
                this.parseErrors.add(e.getException().getMessage());
            }
            if (this.parseErrors.size() > 0) {
                throw new XMLParserException(this.parseErrors);
            }
            Element rootNode = document.getDocumentElement();
            if (rootNode.getNodeType() != 1 || !"ibatorConfiguration".equals(rootNode.getNodeName())) {
                throw new XMLParserException(Messages.getString("RuntimeError.5"));
            }
            IbatorConfiguration ac = this.parseIbatorConfiguration(rootNode);
            if (this.parseErrors.size() > 0) {
                throw new XMLParserException(this.parseErrors);
            }
            return ac;
        }
        catch (ParserConfigurationException e) {
            this.parseErrors.add(e.getMessage());
            throw new XMLParserException(this.parseErrors);
        }
    }

    private IbatorConfiguration parseIbatorConfiguration(Element node) throws XMLParserException {
        IbatorConfiguration ibatorConfiguration = new IbatorConfiguration();
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1) {
                if ("properties".equals(childNode.getNodeName())) {
                    this.parseProperties(ibatorConfiguration, childNode);
                } else if ("classPathEntry".equals(childNode.getNodeName())) {
                    this.parseClassPathEntry(ibatorConfiguration, childNode);
                } else if ("ibatorContext".equals(childNode.getNodeName())) {
                    this.parseIbatorContext(ibatorConfiguration, childNode);
                }
            }
            ++i;
        }
        return ibatorConfiguration;
    }

    private void parseProperties(IbatorConfiguration ibatorConfiguration, Node node) throws XMLParserException {
        Properties attributes = this.parseAttributes(node);
        String resource = attributes.getProperty("resource");
        String url = attributes.getProperty("url");
        if (!StringUtility.stringHasValue(resource) && !StringUtility.stringHasValue(url)) {
            throw new XMLParserException(Messages.getString("RuntimeError.14"));
        }
        if (StringUtility.stringHasValue(resource) && StringUtility.stringHasValue(url)) {
            throw new XMLParserException(Messages.getString("RuntimeError.14"));
        }
        try {
            URL resourceUrl;
            if (StringUtility.stringHasValue(resource)) {
                resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resource);
                if (resourceUrl == null) {
                    throw new XMLParserException(Messages.getString("RuntimeError.15", resource));
                }
            } else {
                resourceUrl = new URL(url);
            }
            InputStream inputStream = resourceUrl.openConnection().getInputStream();
            this.properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            if (StringUtility.stringHasValue(resource)) {
                throw new XMLParserException(Messages.getString("RuntimeError.16", resource));
            }
            throw new XMLParserException(Messages.getString("RuntimeError.17", url));
        }
    }

    private void parseIbatorContext(IbatorConfiguration ibatorConfiguration, Node node) {
        Properties attributes = this.parseAttributes(node);
        String defaultModelType = attributes.getProperty("defaultModelType");
        String targetRuntime = attributes.getProperty("targetRuntime");
        String introspectedColumnImpl = attributes.getProperty("introspectedColumnImpl");
        String id = attributes.getProperty("id");
        ModelType mt = defaultModelType == null ? null : ModelType.getModelType(defaultModelType);
        IbatorContext ibatorContext = new IbatorContext(mt);
        ibatorContext.setId(id);
        if (StringUtility.stringHasValue(introspectedColumnImpl)) {
            ibatorContext.setIntrospectedColumnImpl(introspectedColumnImpl);
        }
        if (StringUtility.stringHasValue(targetRuntime)) {
            ibatorContext.setTargetRuntime(targetRuntime);
        }
        ibatorConfiguration.addIbatorContext(ibatorContext);
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1) {
                if ("property".equals(childNode.getNodeName())) {
                    this.parseProperty(ibatorContext, childNode);
                } else if ("ibatorPlugin".equals(childNode.getNodeName())) {
                    this.parseIbatorPlugin(ibatorContext, childNode);
                } else if ("commentGenerator".equals(childNode.getNodeName())) {
                    this.parseCommentGenerator(ibatorContext, childNode);
                } else if ("jdbcConnection".equals(childNode.getNodeName())) {
                    this.parseJdbcConnection(ibatorContext, childNode);
                } else if ("javaModelGenerator".equals(childNode.getNodeName())) {
                    this.parseJavaModelGenerator(ibatorContext, childNode);
                } else if ("javaTypeResolver".equals(childNode.getNodeName())) {
                    this.parseJavaTypeResolver(ibatorContext, childNode);
                } else if ("sqlMapGenerator".equals(childNode.getNodeName())) {
                    this.parseSqlMapGenerator(ibatorContext, childNode);
                } else if ("daoGenerator".equals(childNode.getNodeName())) {
                    this.parseDaoGenerator(ibatorContext, childNode);
                } else if ("table".equals(childNode.getNodeName())) {
                    this.parseTable(ibatorContext, childNode);
                }
            }
            ++i;
        }
    }

    private void parseSqlMapGenerator(IbatorContext ibatorContext, Node node) {
        SqlMapGeneratorConfiguration sqlMapGeneratorConfiguration = new SqlMapGeneratorConfiguration();
        ibatorContext.setSqlMapGeneratorConfiguration(sqlMapGeneratorConfiguration);
        Properties attributes = this.parseAttributes(node);
        String targetPackage = attributes.getProperty("targetPackage");
        String targetProject = attributes.getProperty("targetProject");
        sqlMapGeneratorConfiguration.setTargetPackage(targetPackage);
        sqlMapGeneratorConfiguration.setTargetProject(targetProject);
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && "property".equals(childNode.getNodeName())) {
                this.parseProperty(sqlMapGeneratorConfiguration, childNode);
            }
            ++i;
        }
    }

    private void parseTable(IbatorContext ibatorContext, Node node) {
        String cacheType;
        TableConfiguration tc = new TableConfiguration(ibatorContext);
        ibatorContext.addTableConfiguration(tc);
        Properties attributes = this.parseAttributes(node);
        String catalog = attributes.getProperty("catalog");
        String schema = attributes.getProperty("schema");
        String tableName = attributes.getProperty("tableName");
        String domainObjectName = attributes.getProperty("domainObjectName");
        String cacheTime = attributes.getProperty("cacheTime");
        try {
            int i;
            if (cacheTime != null && (cacheTime = cacheTime.trim()).equals("") && (i = Integer.valueOf(cacheTime).intValue()) <= 0) {
                cacheTime = "";
            }
        }
        catch (Exception e) {
            cacheTime = "";
        }
        if ((cacheType = attributes.getProperty("cacheType")) != null) {
            cacheType = cacheType.trim().toUpperCase();
        }
        String alias = attributes.getProperty("alias");
        String enableInsert = attributes.getProperty("enableInsert");
        String enableSelectByPrimaryKey = attributes.getProperty("enableSelectByPrimaryKey");
        String enableSelectByExample = attributes.getProperty("enableSelectByExample");
        String enableUpdateByPrimaryKey = attributes.getProperty("enableUpdateByPrimaryKey");
        String enableDeleteByPrimaryKey = attributes.getProperty("enableDeleteByPrimaryKey");
        String enableDeleteByExample = attributes.getProperty("enableDeleteByExample");
        String enableCountByExample = attributes.getProperty("enableCountByExample");
        String enableUpdateByExample = attributes.getProperty("enableUpdateByExample");
        String selectByPrimaryKeyQueryId = attributes.getProperty("selectByPrimaryKeyQueryId");
        String selectByExampleQueryId = attributes.getProperty("selectByExampleQueryId");
        String modelType = attributes.getProperty("modelType");
        String escapeWildcards = attributes.getProperty("escapeWildcards");
        String delimitIdentifiers = attributes.getProperty("delimitIdentifiers");
        String delimitAllColumns = attributes.getProperty("delimitAllColumns");
        if (StringUtility.stringHasValue(catalog)) {
            tc.setCatalog(catalog);
        }
        if (StringUtility.stringHasValue(schema)) {
            tc.setSchema(schema);
        }
        if (StringUtility.stringHasValue(tableName)) {
            tc.setTableName(tableName);
        }
        if (StringUtility.stringHasValue(domainObjectName)) {
            tc.setDomainObjectName(domainObjectName);
        }
        if (StringUtility.stringHasValue(cacheTime)) {
            tc.setCacheTime(cacheTime);
        }
        if (StringUtility.stringHasValue(cacheType)) {
            tc.setCacheType(cacheType);
        }
        if (StringUtility.stringHasValue(alias)) {
            tc.setAlias(alias);
        }
        if (StringUtility.stringHasValue(enableInsert)) {
            tc.setInsertStatementEnabled(StringUtility.isTrue(enableInsert));
        }
        if (StringUtility.stringHasValue(enableSelectByPrimaryKey)) {
            tc.setSelectByPrimaryKeyStatementEnabled(StringUtility.isTrue(enableSelectByPrimaryKey));
        }
        if (StringUtility.stringHasValue(enableSelectByExample)) {
            tc.setSelectByExampleStatementEnabled(StringUtility.isTrue(enableSelectByExample));
        }
        if (StringUtility.stringHasValue(enableUpdateByPrimaryKey)) {
            tc.setUpdateByPrimaryKeyStatementEnabled(StringUtility.isTrue(enableUpdateByPrimaryKey));
        }
        if (StringUtility.stringHasValue(enableDeleteByPrimaryKey)) {
            tc.setDeleteByPrimaryKeyStatementEnabled(StringUtility.isTrue(enableDeleteByPrimaryKey));
        }
        if (StringUtility.stringHasValue(enableDeleteByExample)) {
            tc.setDeleteByExampleStatementEnabled(StringUtility.isTrue(enableDeleteByExample));
        }
        if (StringUtility.stringHasValue(enableCountByExample)) {
            tc.setCountByExampleStatementEnabled(StringUtility.isTrue(enableCountByExample));
        }
        if (StringUtility.stringHasValue(enableUpdateByExample)) {
            tc.setUpdateByExampleStatementEnabled(StringUtility.isTrue(enableUpdateByExample));
        }
        if (StringUtility.stringHasValue(selectByPrimaryKeyQueryId)) {
            tc.setSelectByPrimaryKeyQueryId(selectByPrimaryKeyQueryId);
        }
        if (StringUtility.stringHasValue(selectByExampleQueryId)) {
            tc.setSelectByExampleQueryId(selectByExampleQueryId);
        }
        if (StringUtility.stringHasValue(modelType)) {
            tc.setConfiguredModelType(modelType);
        }
        if (StringUtility.stringHasValue(escapeWildcards)) {
            tc.setWildcardEscapingEnabled(StringUtility.isTrue(escapeWildcards));
        }
        if (StringUtility.stringHasValue(delimitIdentifiers)) {
            tc.setDelimitIdentifiers(StringUtility.isTrue(delimitIdentifiers));
        }
        if (StringUtility.stringHasValue(delimitAllColumns)) {
            tc.setAllColumnDelimitingEnabled(StringUtility.isTrue(delimitAllColumns));
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1) {
                if ("property".equals(childNode.getNodeName())) {
                    this.parseProperty(tc, childNode);
                } else if ("columnOverride".equals(childNode.getNodeName())) {
                    this.parseColumnOverride(tc, childNode);
                } else if ("ignoreColumn".equals(childNode.getNodeName())) {
                    this.parseIgnoreColumn(tc, childNode);
                } else if ("generatedKey".equals(childNode.getNodeName())) {
                    this.parseGeneratedKey(tc, childNode);
                } else if ("columnRenamingRule".equals(childNode.getNodeName())) {
                    this.parseColumnRenamingRule(tc, childNode);
                }
            }
            ++i;
        }
    }

    private void parseColumnOverride(TableConfiguration tc, Node node) {
        Properties attributes = this.parseAttributes(node);
        String column = attributes.getProperty("column");
        String property = attributes.getProperty("property");
        String javaType = attributes.getProperty("javaType");
        String jdbcType = attributes.getProperty("jdbcType");
        String typeHandler = attributes.getProperty("typeHandler");
        String delimitedColumnName = attributes.getProperty("delimitedColumnName");
        ColumnOverride co = new ColumnOverride(column);
        if (StringUtility.stringHasValue(property)) {
            co.setJavaProperty(property);
        }
        if (StringUtility.stringHasValue(javaType)) {
            co.setJavaType(javaType);
        }
        if (StringUtility.stringHasValue(jdbcType)) {
            co.setJdbcType(jdbcType);
        }
        if (StringUtility.stringHasValue(typeHandler)) {
            co.setTypeHandler(typeHandler);
        }
        if (StringUtility.stringHasValue(delimitedColumnName)) {
            co.setColumnNameDelimited(StringUtility.isTrue(delimitedColumnName));
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && "property".equals(childNode.getNodeName())) {
                this.parseProperty(co, childNode);
            }
            ++i;
        }
        tc.addColumnOverride(co);
    }

    private void parseGeneratedKey(TableConfiguration tc, Node node) {
        Properties attributes = this.parseAttributes(node);
        String column = attributes.getProperty("column");
        boolean identity = StringUtility.isTrue(attributes.getProperty("identity"));
        String sqlStatement = attributes.getProperty("sqlStatement");
        String type = attributes.getProperty("type");
        GeneratedKey gk = new GeneratedKey(column, sqlStatement, identity, type);
        tc.setGeneratedKey(gk);
    }

    private void parseIgnoreColumn(TableConfiguration tc, Node node) {
        Properties attributes = this.parseAttributes(node);
        String column = attributes.getProperty("column");
        String delimitedColumnName = attributes.getProperty("delimitedColumnName");
        IgnoredColumn ic = new IgnoredColumn(column);
        if (StringUtility.stringHasValue(delimitedColumnName)) {
            ic.setColumnNameDelimited(StringUtility.isTrue(delimitedColumnName));
        }
        tc.addIgnoredColumn(ic);
    }

    private void parseColumnRenamingRule(TableConfiguration tc, Node node) {
        Properties attributes = this.parseAttributes(node);
        String searchString = attributes.getProperty("searchString");
        String replaceString = attributes.getProperty("replaceString");
        ColumnRenamingRule crr = new ColumnRenamingRule();
        crr.setSearchString(searchString);
        if (StringUtility.stringHasValue(replaceString)) {
            crr.setReplaceString(replaceString);
        }
        tc.setColumnRenamingRule(crr);
    }

    private void parseJavaTypeResolver(IbatorContext ibatorContext, Node node) {
        JavaTypeResolverConfiguration javaTypeResolverConfiguration = new JavaTypeResolverConfiguration();
        ibatorContext.setJavaTypeResolverConfiguration(javaTypeResolverConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        if (StringUtility.stringHasValue(type)) {
            javaTypeResolverConfiguration.setConfigurationType(type);
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && "property".equals(childNode.getNodeName())) {
                this.parseProperty(javaTypeResolverConfiguration, childNode);
            }
            ++i;
        }
    }

    private void parseIbatorPlugin(IbatorContext ibatorContext, Node node) {
        IbatorPluginConfiguration ibatorPluginConfiguration = new IbatorPluginConfiguration();
        ibatorContext.addPluginConfiguration(ibatorPluginConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        ibatorPluginConfiguration.setConfigurationType(type);
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && "property".equals(childNode.getNodeName())) {
                this.parseProperty(ibatorPluginConfiguration, childNode);
            }
            ++i;
        }
    }

    private void parseJavaModelGenerator(IbatorContext ibatorContext, Node node) {
        JavaModelGeneratorConfiguration javaModelGeneratorConfiguration = new JavaModelGeneratorConfiguration();
        ibatorContext.setJavaModelGeneratorConfiguration(javaModelGeneratorConfiguration);
        Properties attributes = this.parseAttributes(node);
        String targetPackage = attributes.getProperty("targetPackage");
        String targetProject = attributes.getProperty("targetProject");
        javaModelGeneratorConfiguration.setTargetPackage(targetPackage);
        javaModelGeneratorConfiguration.setTargetProject(targetProject);
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && "property".equals(childNode.getNodeName())) {
                this.parseProperty(javaModelGeneratorConfiguration, childNode);
            }
            ++i;
        }
    }

    private void parseDaoGenerator(IbatorContext ibatorContext, Node node) {
        DAOGeneratorConfiguration daoGeneratorConfiguration = new DAOGeneratorConfiguration();
        ibatorContext.setDaoGeneratorConfiguration(daoGeneratorConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        String targetPackage = attributes.getProperty("targetPackage");
        String targetProject = attributes.getProperty("targetProject");
        String implementationPackage = attributes.getProperty("implementationPackage");
        daoGeneratorConfiguration.setConfigurationType(type);
        daoGeneratorConfiguration.setTargetPackage(targetPackage);
        daoGeneratorConfiguration.setTargetProject(targetProject);
        daoGeneratorConfiguration.setImplementationPackage(implementationPackage);
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && "property".equals(childNode.getNodeName())) {
                this.parseProperty(daoGeneratorConfiguration, childNode);
            }
            ++i;
        }
    }

    private void parseJdbcConnection(IbatorContext ibatorContext, Node node) {
        JDBCConnectionConfiguration jdbcConnectionConfiguration = new JDBCConnectionConfiguration();
        ibatorContext.setJdbcConnectionConfiguration(jdbcConnectionConfiguration);
        Properties attributes = this.parseAttributes(node);
        String driverClass = attributes.getProperty("driverClass");
        String connectionURL = attributes.getProperty("connectionURL");
        String userId = attributes.getProperty("userId");
        String password = attributes.getProperty("password");
        jdbcConnectionConfiguration.setDriverClass(driverClass);
        jdbcConnectionConfiguration.setConnectionURL(connectionURL);
        if (StringUtility.stringHasValue(userId)) {
            jdbcConnectionConfiguration.setUserId(userId);
        }
        if (StringUtility.stringHasValue(password)) {
            jdbcConnectionConfiguration.setPassword(password);
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && "property".equals(childNode.getNodeName())) {
                this.parseProperty(jdbcConnectionConfiguration, childNode);
            }
            ++i;
        }
    }

    private void parseClassPathEntry(IbatorConfiguration ibatorConfiguration, Node node) {
        Properties attributes = this.parseAttributes(node);
        ibatorConfiguration.addClasspathEntry(attributes.getProperty("location"));
    }

    private void parseProperty(PropertyHolder propertyHolder, Node node) {
        Properties attributes = this.parseAttributes(node);
        String name = attributes.getProperty("name");
        String value = attributes.getProperty("value");
        propertyHolder.addProperty(name, value);
    }

    private Properties parseAttributes(Node node) {
        Properties attributes = new Properties();
        NamedNodeMap nnm = node.getAttributes();
        int i = 0;
        while (i < nnm.getLength()) {
            Node attribute = nnm.item(i);
            String value = this.parsePropertyTokens(attribute.getNodeValue());
            attributes.put(attribute.getNodeName(), value);
            ++i;
        }
        return attributes;
    }

    private String parsePropertyTokens(String string) {
        String OPEN = "${";
        String CLOSE = "}";
        String newString = string;
        if (newString != null) {
            int start = newString.indexOf("${");
            int end = newString.indexOf("}");
            while (start > -1 && end > start) {
                String prepend = newString.substring(0, start);
                String append = newString.substring(end + "}".length());
                String propName = newString.substring(start + "${".length(), end);
                String propValue = this.properties.getProperty(propName);
                if (propValue != null) {
                    newString = String.valueOf(prepend) + propValue + append;
                }
                start = newString.indexOf("${", end);
                end = newString.indexOf("}", end);
            }
        }
        return newString;
    }

    private void parseCommentGenerator(IbatorContext ibatorContext, Node node) {
        CommentGeneratorConfiguration commentGeneratorConfiguration = new CommentGeneratorConfiguration();
        ibatorContext.setCommentGeneratorConfiguration(commentGeneratorConfiguration);
        Properties attributes = this.parseAttributes(node);
        String type = attributes.getProperty("type");
        if (StringUtility.stringHasValue(type)) {
            commentGeneratorConfiguration.setConfigurationType(type);
        }
        NodeList nodeList = node.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && "property".equals(childNode.getNodeName())) {
                this.parseProperty(commentGeneratorConfiguration, childNode);
            }
            ++i;
        }
    }
}

