/*
 * Decompiled with CFR 0.152.
 */
package com.miniframe.designer.engine;

import com.miniframe.designer.engine.MiniVelocityEngine;
import com.miniframe.designer.model.CodeInfo;
import com.miniframe.designer.model.XmlConfMap;
import com.miniframe.designer.util.DesignerTools;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;

public class JsonCommTransEngine
extends MiniVelocityEngine {
    private static final Logger logger = Logger.getLogger(JsonCommTransEngine.class);
    private String javaTemplate;
    private String javaDir;
    private String formTemplate;
    private String formDir;
    private String formMsgTemplate;
    private String formMsgDir;

    public static void main(String[] args) throws Exception {
        String ruleDir = MiniVelocityEngine.getDir("ruleDir");
        String appcodeDir = MiniVelocityEngine.getDir("appcodeDir");
        String javaTemplate = MiniVelocityEngine.getSysProperty("javaTemplate");
        String javaDir = MiniVelocityEngine.getDir("javaDir");
        String formTemplate = MiniVelocityEngine.getSysProperty("formTemplate");
        String formDir = MiniVelocityEngine.getDir("formDir");
        String formMsgTemplate = MiniVelocityEngine.getSysProperty("formMsgTemplate");
        String formMsgDir = MiniVelocityEngine.getDir("formMsgDir");
        File fileDir = new File(MiniVelocityEngine.getDir("dataDir"));
        String[] files = fileDir.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".csv")) continue;
                XmlConfMap model = new XmlConfMap(MiniVelocityEngine.getDir("dataDir") + files[i], ruleDir, appcodeDir);
                JsonCommTransEngine engine = new JsonCommTransEngine();
                engine.setFormDir(formDir);
                engine.setFormMsgDir(formMsgDir);
                engine.setJavaDir(javaDir + model.getSortCode().toLowerCase() + "/");
                engine.setFormTemplate(formTemplate);
                engine.setJavaTemplate(javaTemplate);
                engine.setFormMsgTemplate(formMsgTemplate);
                engine.modelCheck(model);
            }
        }
    }

    private CodeInfo map2CodeInfo(Map model) {
        CodeInfo codeinfo = new CodeInfo();
        codeinfo.setCode((String)model.get("code"));
        codeinfo.setName((String)model.get("name"));
        for (Map.Entry entry : model.entrySet()) {
            Map map;
            String dataType;
            Object obj = entry.getValue();
            if (!(obj instanceof Map) || (dataType = (String)(map = (Map)obj).get("\u6570\u636e\u7c7b\u578b")).equals("list") || dataType.equals("map") || dataType.equals("include")) continue;
            codeinfo.getList().add((Map)obj);
        }
        return codeinfo;
    }

    public boolean formGenerator(Map model) {
        CodeInfo codeinfo = this.map2CodeInfo(model);
        File file = new File(this.formTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.formTemplate + " ] \u4e0d\u5b58\u5728!"));
            return false;
        }
        Map<?, ?> map = JsonCommTransEngine.obj2Map(codeinfo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("VelocityContext - " + map.toString()));
        }
        VelocityContext ctx = new VelocityContext();
        ctx.put("map", map);
        try {
            String fileName = DesignerTools.toLower(codeinfo.getCode());
            String value = MiniVelocityEngine.encode(ctx, this.formTemplate);
            if (value.indexOf("<field") > 0) {
                MiniVelocityEngine.writefile(value, this.formDir + fileName + "Form.xml");
                return true;
            }
        }
        catch (Exception var8) {
            logger.error((Object)"\u751f\u6210\u6587\u4ef6\u9519\u8bef:", (Throwable)var8);
        }
        return false;
    }

    public void formMsgGenerator(Map model) {
        CodeInfo codeinfo = this.map2CodeInfo(model);
        File file = new File(this.formMsgTemplate);
        if (!file.exists()) {
            logger.error((Object)("[ " + this.formMsgTemplate + " ] \u4e0d\u5b58\u5728!"));
        } else {
            Map<?, ?> map = JsonCommTransEngine.obj2Map(codeinfo);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("VelocityContext - " + map.toString()));
            }
            VelocityContext ctx = new VelocityContext();
            ctx.put("map", map);
            try {
                String fileName = DesignerTools.toLower(codeinfo.getCode()) + "Form";
                String fileName1 = "resources_" + fileName + "_validator_zh_CN.properties";
                String fileName2 = "resources_" + fileName + "_validator.properties";
                String context = MiniVelocityEngine.encode(ctx, this.formMsgTemplate);
                if (context.trim().length() > 0) {
                    context = context + fileName + " = true";
                    MiniVelocityEngine.writefile(context, this.formMsgDir + fileName1);
                    MiniVelocityEngine.writefile(context, this.formMsgDir + fileName2);
                } else {
                    context = fileName + " = false";
                    MiniVelocityEngine.writefile(context, this.formMsgDir + fileName1);
                    MiniVelocityEngine.writefile(context, this.formMsgDir + fileName2);
                }
            }
            catch (Exception var10) {
                logger.error((Object)"\u751f\u6210\u6587\u4ef6\u9519\u8bef:", (Throwable)var10);
            }
        }
    }

    public void modelCheck(Map model) {
        if (model.get("code") != null) {
            this.javaGenerator(model);
            this.formGenerator(model);
            this.formMsgGenerator(model);
            for (Map.Entry entry : model.entrySet()) {
                Map map;
                Object obj = entry.getValue();
                if (!(obj instanceof Map) || (map = (Map)obj).get("code") == null) continue;
                this.modelCheck(map);
            }
        }
    }

    public void javaGenerator(Map model) {
        VelocityContext ctx = new VelocityContext();
        LinkedHashMap map = new LinkedHashMap();
        map.put("code", model.get("code"));
        map.put("name", model.get("name"));
        map.put("sortCode", model.get("sortCode"));
        map.put("sortName", model.get("sortName"));
        for (Map.Entry entry : model.entrySet()) {
            Object obj = entry.getValue();
            if (!(obj instanceof Map)) continue;
            map.put((String)entry.getKey(), obj);
        }
        ctx.put("map", map);
        ctx.put("engine", (Object)this);
        try {
            MiniVelocityEngine.writefile(MiniVelocityEngine.encode(ctx, this.javaTemplate), this.javaDir + DesignerTools.getClassName(model.get("code").toString()) + ".java");
        }
        catch (Exception var7) {
            logger.error((Object)"\u751f\u6210\u6587\u4ef6\u9519\u8bef:", (Throwable)var7);
        }
    }

    public String getJavaTemplate() {
        return this.javaTemplate;
    }

    public void setJavaTemplate(String javaTemplate) {
        this.javaTemplate = javaTemplate;
    }

    public String getJavaDir() {
        return this.javaDir;
    }

    public void setJavaDir(String javaDir) {
        this.javaDir = javaDir;
    }

    public String getFormTemplate() {
        return this.formTemplate;
    }

    public void setFormTemplate(String formTemplate) {
        this.formTemplate = formTemplate;
    }

    public String getFormDir() {
        return this.formDir;
    }

    public void setFormDir(String formDir) {
        this.formDir = formDir;
    }

    public String getFormMsgTemplate() {
        return this.formMsgTemplate;
    }

    public void setFormMsgTemplate(String formMsgTemplate) {
        this.formMsgTemplate = formMsgTemplate;
    }

    public String getFormMsgDir() {
        return this.formMsgDir;
    }

    public void setFormMsgDir(String formMsgDir) {
        this.formMsgDir = formMsgDir;
    }
}

