/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.config;

import java.util.List;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.internal.util.StringUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoredColumn {
    private String columnName;
    private boolean isColumnNameDelimited;
    private String configuredDelimitedColumnName;

    public IgnoredColumn(String columnName) {
        this.columnName = columnName;
        this.isColumnNameDelimited = StringUtility.stringContainsSpace(columnName);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isColumnNameDelimited() {
        return this.isColumnNameDelimited;
    }

    public void setColumnNameDelimited(boolean isColumnNameDelimited) {
        this.isColumnNameDelimited = isColumnNameDelimited;
        this.configuredDelimitedColumnName = isColumnNameDelimited ? "true" : "false";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IgnoredColumn)) {
            return false;
        }
        return this.columnName.equals(((IgnoredColumn)obj).getColumnName());
    }

    public int hashCode() {
        return this.columnName.hashCode();
    }

    public XmlElement toXmlElement() {
        XmlElement xmlElement = new XmlElement("ignoreColumn");
        xmlElement.addAttribute(new Attribute("column", this.columnName));
        if (StringUtility.stringHasValue(this.configuredDelimitedColumnName)) {
            xmlElement.addAttribute(new Attribute("delimitedColumnName", this.configuredDelimitedColumnName));
        }
        return xmlElement;
    }

    public void validate(List<String> errors, String tableName) {
        if (!StringUtility.stringHasValue(this.columnName)) {
            errors.add(Messages.getString("ValidationError.21", tableName));
        }
    }
}

