/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.config;

import java.util.List;
import org.apache.ibatis.ibator.api.dom.xml.Attribute;
import org.apache.ibatis.ibator.api.dom.xml.XmlElement;
import org.apache.ibatis.ibator.config.PropertyHolder;
import org.apache.ibatis.ibator.internal.util.StringUtility;
import org.apache.ibatis.ibator.internal.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCConnectionConfiguration
extends PropertyHolder {
    public static String dbType;
    private String driverClass;
    private String connectionURL;
    private String userId;
    private String password;

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        this.connectionURL = connectionURL;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDriverClass() {
        dbType = this.driverClass;
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        dbType = driverClass;
        this.driverClass = driverClass;
    }

    public XmlElement toXmlElement() {
        XmlElement xmlElement = new XmlElement("jdbcConnection");
        xmlElement.addAttribute(new Attribute("driverClass", this.driverClass));
        xmlElement.addAttribute(new Attribute("connectionURL", this.connectionURL));
        if (StringUtility.stringHasValue(this.userId)) {
            xmlElement.addAttribute(new Attribute("userId", this.userId));
        }
        if (StringUtility.stringHasValue(this.password)) {
            xmlElement.addAttribute(new Attribute("password", this.password));
        }
        this.addPropertyXmlElements(xmlElement);
        return xmlElement;
    }

    public void validate(List<String> errors) {
        if (!StringUtility.stringHasValue(this.driverClass)) {
            errors.add(Messages.getString("ValidationError.4"));
        }
        if (!StringUtility.stringHasValue(this.connectionURL)) {
            errors.add(Messages.getString("ValidationError.5"));
        }
    }
}

