/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReadWriteCache
implements CacheConcurrencyStrategy {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$cache$ReadWriteCache == null ? (class$net$sf$hibernate$cache$ReadWriteCache = ReadWriteCache.class$("net.sf.hibernate.cache.ReadWriteCache")) : class$net$sf$hibernate$cache$ReadWriteCache));
    private Cache cache;
    private int nextLockId;
    static /* synthetic */ Class class$net$sf$hibernate$cache$ReadWriteCache;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    private int nextLockId() {
        if (this.nextLockId == Integer.MAX_VALUE) {
            this.nextLockId = Integer.MIN_VALUE;
        }
        return this.nextLockId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object get(Object key, long txTimestamp) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cache lookup: " + key));
        }
        try {
            boolean gettable;
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            boolean bl = gettable = lockable != null && lockable.isGettable(txTimestamp);
            if (gettable) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Cache hit: " + key));
                }
                Object object = ((Item)lockable).getValue();
                return object;
            }
            if (log.isTraceEnabled()) {
                if (lockable == null) {
                    log.trace((Object)("Cache miss: " + key));
                } else {
                    log.trace((Object)("Cached item was locked: " + key));
                }
            }
            Object var6_6 = null;
            return var6_6;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CacheConcurrencyStrategy.SoftLock lock(Object key, Object version) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invalidating: " + key));
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            long timeout = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
            Lock lock = lockable == null ? new Lock(timeout, this.nextLockId(), version) : lockable.lock(timeout, this.nextLockId());
            this.cache.put(key, lock);
            Lock lock2 = lock;
            return lock2;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean put(Object key, Object value, long txTimestamp, Object version, Comparator versionComparator) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Caching: " + key));
        }
        try {
            boolean puttable;
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            boolean bl = puttable = lockable == null || lockable.isPuttable(txTimestamp, version, versionComparator);
            if (puttable) {
                this.cache.put(key, new Item(value, this.cache.nextTimestamp(), version));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Cached: " + key));
                }
                boolean bl2 = true;
                return bl2;
            }
            if (log.isTraceEnabled()) {
                if (lockable.isLock()) {
                    log.trace((Object)("Item was locked: " + key));
                } else {
                    log.trace((Object)("Item was already cached: " + key));
                }
            }
            boolean bl3 = false;
            return bl3;
        }
        finally {
            this.cache.unlock(key);
        }
    }

    private void decrementLock(Object key, Lock lock) throws CacheException {
        lock.unlock(this.cache.nextTimestamp());
        this.cache.put(key, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(Object key, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Releasing: " + key));
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (this.isUnlockable(clientLock, lockable)) {
                this.decrementLock(key, (Lock)lockable);
            } else {
                this.handleLockExpiry(key);
            }
        }
        finally {
            this.cache.unlock(key);
        }
    }

    void handleLockExpiry(Object key) throws CacheException {
        log.warn((Object)("An item was expired by the cache while it was locked (increase your cache timeout): " + key));
        long ts = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
        Lock lock = new Lock(ts, this.nextLockId(), null);
        lock.unlock(ts);
        this.cache.put(key, lock);
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn((Object)"could not destroy cache", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterUpdate(Object key, Object value, Object version, CacheConcurrencyStrategy.SoftLock clientLock) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Updating: " + key));
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (this.isUnlockable(clientLock, lockable)) {
                Lock lock = (Lock)lockable;
                if (lock.wasLockedConcurrently()) {
                    this.decrementLock(key, lock);
                } else {
                    this.cache.put(key, new Item(value, this.cache.nextTimestamp(), version));
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Updated: " + key));
                    }
                }
            } else {
                this.handleLockExpiry(key);
            }
        }
        finally {
            this.cache.unlock(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterInsert(Object key, Object value, Object version) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Inserting: " + key));
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (lockable == null) {
                this.cache.put(key, new Item(value, this.cache.nextTimestamp(), version));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Inserted: " + key));
                }
            }
        }
        finally {
            this.cache.unlock(key);
        }
    }

    public void evict(Object key) throws CacheException {
    }

    public void insert(Object key, Object value) throws CacheException {
    }

    public void update(Object key, Object value) throws CacheException {
    }

    private boolean isUnlockable(CacheConcurrencyStrategy.SoftLock clientLock, Lockable myLock) throws CacheException {
        return myLock != null && myLock.isLock() && clientLock != null && ((Lock)clientLock).getId() == ((Lock)myLock).getId();
    }

    public void setMinimalPuts(boolean minimalPuts) throws HibernateException {
        if (minimalPuts) {
            throw new HibernateException("minimal puts not supported for read-write cache");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class Lock
    implements Serializable,
    Lockable,
    CacheConcurrencyStrategy.SoftLock {
        private long unlockTimestamp = -1L;
        private int multiplicity = 1;
        private boolean concurrentLock = false;
        private long timeout;
        private final int id;
        private final Object version;

        public Lock(long timeout, int id, Object version) {
            this.timeout = timeout;
            this.id = id;
            this.version = version;
        }

        public long getUnlockTimestamp() {
            return this.unlockTimestamp;
        }

        public Lock lock(long timeout, int id) {
            this.concurrentLock = true;
            ++this.multiplicity;
            this.timeout = timeout;
            return this;
        }

        public void unlock(long currentTimestamp) {
            if (--this.multiplicity == 0) {
                this.unlockTimestamp = currentTimestamp;
            }
        }

        public boolean isPuttable(long txTimestamp, Object newVersion, Comparator comparator) {
            if (this.timeout < txTimestamp) {
                return true;
            }
            if (this.multiplicity > 0) {
                return false;
            }
            return this.version == null ? this.unlockTimestamp < txTimestamp : comparator.compare(this.version, newVersion) < 0;
        }

        public boolean wasLockedConcurrently() {
            return this.concurrentLock;
        }

        public boolean isLock() {
            return true;
        }

        public boolean isGettable(long txTimestamp) {
            return false;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "Lock{id=" + this.id + ",version=" + this.version + ",multiplicity=" + this.multiplicity + ",unlockTimestamp=" + this.unlockTimestamp;
        }
    }

    public static final class Item
    implements Serializable,
    Lockable {
        private final long freshTimestamp;
        private final Object value;
        private final Object version;

        public Item(Object value, long currentTimestamp, Object version) {
            this.value = value;
            this.freshTimestamp = currentTimestamp;
            this.version = version;
        }

        public long getFreshTimestamp() {
            return this.freshTimestamp;
        }

        public Object getValue() {
            return this.value;
        }

        public Lock lock(long timeout, int id) {
            return new Lock(timeout, id, this.version);
        }

        public boolean isLock() {
            return false;
        }

        public boolean isGettable(long txTimestamp) {
            return this.freshTimestamp < txTimestamp;
        }

        public boolean isPuttable(long txTimestamp, Object newVersion, Comparator comparator) {
            return this.version != null && comparator.compare(this.version, newVersion) < 0;
        }

        public String toString() {
            return "Item{version=" + this.version + ",freshTimestamp=" + this.freshTimestamp;
        }
    }

    public static interface Lockable {
        public Lock lock(long var1, int var3);

        public boolean isLock();

        public boolean isGettable(long var1);

        public boolean isPuttable(long var1, Object var3, Comparator var4);
    }
}

