/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.api.dom.java;

import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;
import org.junit.Assert;
import org.junit.Test;

public class FullyQualifiedJavaTypeTest {
    @Test
    public void testJavaType() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.lang.String");
        Assert.assertFalse((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"String", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.lang.String", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.lang", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)0L, (long)fqjt.getImportList().size());
    }

    @Test
    public void testSimpleType() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("com.foo.Bar");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"Bar", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"com.foo.Bar", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"com.foo", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)1L, (long)fqjt.getImportList().size());
        Assert.assertEquals((Object)"com.foo.Bar", (Object)fqjt.getImportList().get(0));
    }

    @Test
    public void testGenericType1() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.List<java.lang.String>");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"List<String>", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.util.List<java.lang.String>", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)1L, (long)fqjt.getImportList().size());
        Assert.assertEquals((Object)"java.util.List", (Object)fqjt.getImportList().get(0));
    }

    @Test
    public void testGenericType2() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.Map<java.lang.String, java.util.List<java.lang.String>>");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"Map<String, List<String>>", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.util.Map<java.lang.String, java.util.List<java.lang.String>>", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)2L, (long)fqjt.getImportList().size());
    }

    @Test
    public void testGenericType3() {
        FullyQualifiedJavaType listOfStrings = new FullyQualifiedJavaType("java.util.List");
        listOfStrings.addTypeArgument(new FullyQualifiedJavaType("java.lang.String"));
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.Map");
        fqjt.addTypeArgument(new FullyQualifiedJavaType("java.lang.String"));
        fqjt.addTypeArgument(listOfStrings);
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"Map<String, List<String>>", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.util.Map<java.lang.String, java.util.List<java.lang.String>>", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)2L, (long)fqjt.getImportList().size());
    }

    @Test
    public void testGenericType4() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.List<java.util.Map<java.lang.String, java.lang.Object>>");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"List<Map<String, Object>>", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.util.List<java.util.Map<java.lang.String, java.lang.Object>>", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)2L, (long)fqjt.getImportList().size());
    }

    @Test
    public void testWildcardType1() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.Map<java.lang.String, ? extends com.foo.Bar>");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"Map<String, ? extends Bar>", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.util.Map<java.lang.String, ? extends com.foo.Bar>", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)2L, (long)fqjt.getImportList().size());
    }

    @Test
    public void testWildcardType2() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.Map<java.lang.String, ?>");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"Map<String, ?>", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.util.Map<java.lang.String, ?>", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)1L, (long)fqjt.getImportList().size());
        Assert.assertEquals((Object)"java.util.Map", (Object)fqjt.getImportList().get(0));
    }

    @Test
    public void testWildcardType3() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.Map<? extends java.util.List<?>, ?>");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"Map<? extends List<?>, ?>", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.util.Map<? extends java.util.List<?>, ?>", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)2L, (long)fqjt.getImportList().size());
    }

    @Test
    public void testWildcardType4() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.Map<?, ?>");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"Map<?, ?>", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.util.Map<?, ?>", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)1L, (long)fqjt.getImportList().size());
        Assert.assertEquals((Object)"java.util.Map", (Object)fqjt.getImportList().get(0));
    }

    @Test
    public void testWildcardType5() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.List<? extends java.util.Map<? super java.lang.Object, ?>>");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"List<? extends Map<? super Object, ?>>", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.util.List<? extends java.util.Map<? super java.lang.Object, ?>>", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)2L, (long)fqjt.getImportList().size());
    }

    @Test
    public void testNestedClass1() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("org.foo.Bar.Inner");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"Bar.Inner", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"org.foo.Bar.Inner", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"org.foo", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)1L, (long)fqjt.getImportList().size());
        Assert.assertEquals((Object)"org.foo.Bar", (Object)fqjt.getImportList().get(0));
    }

    @Test
    public void testNestedClass2() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("org.foo.Bar.Inner.Inner");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"Bar.Inner.Inner", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"org.foo.Bar.Inner.Inner", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"org.foo", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)1L, (long)fqjt.getImportList().size());
        Assert.assertEquals((Object)"org.foo.Bar", (Object)fqjt.getImportList().get(0));
    }

    @Test
    public void testNestedClass3() {
        FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType("java.util.List<org.foo.Bar.Inner>");
        Assert.assertTrue((boolean)fqjt.isExplicitlyImported());
        Assert.assertEquals((Object)"List<Bar.Inner>", (Object)fqjt.getShortName());
        Assert.assertEquals((Object)"java.util.List<org.foo.Bar.Inner>", (Object)fqjt.getFullyQualifiedName());
        Assert.assertEquals((Object)"java.util", (Object)fqjt.getPackageName());
        Assert.assertEquals((long)2L, (long)fqjt.getImportList().size());
        Assert.assertTrue((boolean)fqjt.getImportList().contains("java.util.List"));
        Assert.assertTrue((boolean)fqjt.getImportList().contains("org.foo.Bar"));
    }
}

