/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ibator.api.dom.java;

import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.ibator.api.dom.java.FullyQualifiedJavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter {
    private String name;
    private FullyQualifiedJavaType type;
    private List<String> annotations;

    public Parameter(FullyQualifiedJavaType type, String name) {
        this.name = name;
        this.type = type;
        this.annotations = new ArrayList<String>();
    }

    public Parameter(FullyQualifiedJavaType type, String name, String annotation) {
        this(type, name);
        this.addAnnotation(annotation);
    }

    public String getName() {
        return this.name;
    }

    public FullyQualifiedJavaType getType() {
        return this.type;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(String annotation) {
        this.annotations.add(annotation);
    }

    public String getFormattedContent() {
        StringBuilder sb = new StringBuilder();
        for (String annotation : this.annotations) {
            sb.append(annotation);
            sb.append(' ');
        }
        sb.append(this.type.getShortName());
        sb.append(' ');
        sb.append(this.name);
        return sb.toString();
    }

    public String toString() {
        return this.getFormattedContent();
    }
}

